/*
 * Decompiled with CFR 0.152.
 */
package com.guagua.guagua.image.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b;\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001XB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020\u00042\u0006\u0010O\u001a\u00020@J\u0010\u0010P\u001a\u0004\u0018\u00010I2\u0006\u0010Q\u001a\u00020@J\u000e\u0010R\u001a\u00020\u00042\u0006\u0010O\u001a\u00020@J\u000e\u0010S\u001a\u00020T2\u0006\u0010N\u001a\u00020\u0004J\u000e\u0010S\u001a\u00020T2\u0006\u0010Q\u001a\u00020@J\u000e\u0010U\u001a\u00020T2\u0006\u0010N\u001a\u00020\u0004J\u000e\u0010V\u001a\u00020T2\u0006\u0010N\u001a\u00020\u0004J\u000e\u0010W\u001a\u00020T2\u0006\u0010N\u001a\u00020\u0004J\u000e\u0010W\u001a\u00020T2\u0006\u0010Q\u001a\u00020@R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0014\u0010\u001f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0014\u0010#\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0014\u0010%\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0014\u0010'\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0014\u0010)\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0014\u0010+\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0014\u0010-\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0014\u0010/\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0014\u00101\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0014\u00103\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0006R\u000e\u00105\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\u00020@X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010B\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020I0HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010J\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u00040HX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/guagua/guagua/image/utils/MediaFileUtil;", "", "()V", "FILE_TYPE_3GPP", "", "getFILE_TYPE_3GPP", "()I", "FILE_TYPE_3GPP2", "getFILE_TYPE_3GPP2", "FILE_TYPE_AMR", "getFILE_TYPE_AMR", "FILE_TYPE_AWB", "getFILE_TYPE_AWB", "FILE_TYPE_BMP", "getFILE_TYPE_BMP", "FILE_TYPE_GIF", "getFILE_TYPE_GIF", "FILE_TYPE_HEIC", "getFILE_TYPE_HEIC", "FILE_TYPE_IMY", "getFILE_TYPE_IMY", "FILE_TYPE_JPEG", "getFILE_TYPE_JPEG", "FILE_TYPE_M3U", "getFILE_TYPE_M3U", "FILE_TYPE_M4A", "getFILE_TYPE_M4A", "FILE_TYPE_M4V", "getFILE_TYPE_M4V", "FILE_TYPE_MID", "getFILE_TYPE_MID", "FILE_TYPE_MP3", "getFILE_TYPE_MP3", "FILE_TYPE_MP4", "getFILE_TYPE_MP4", "FILE_TYPE_OGG", "getFILE_TYPE_OGG", "FILE_TYPE_PLS", "getFILE_TYPE_PLS", "FILE_TYPE_PNG", "getFILE_TYPE_PNG", "FILE_TYPE_SMF", "getFILE_TYPE_SMF", "FILE_TYPE_WAV", "getFILE_TYPE_WAV", "FILE_TYPE_WBMP", "getFILE_TYPE_WBMP", "FILE_TYPE_WMA", "getFILE_TYPE_WMA", "FILE_TYPE_WMV", "getFILE_TYPE_WMV", "FILE_TYPE_WPL", "getFILE_TYPE_WPL", "FIRST_AUDIO_FILE_TYPE", "FIRST_IMAGE_FILE_TYPE", "FIRST_MIDI_FILE_TYPE", "FIRST_PLAYLIST_FILE_TYPE", "FIRST_VIDEO_FILE_TYPE", "LAST_AUDIO_FILE_TYPE", "LAST_IMAGE_FILE_TYPE", "LAST_MIDI_FILE_TYPE", "LAST_PLAYLIST_FILE_TYPE", "LAST_VIDEO_FILE_TYPE", "UNKNOWN_STRING", "", "getUNKNOWN_STRING", "()Ljava/lang/String;", "sFileExtensions", "getSFileExtensions", "setSFileExtensions", "(Ljava/lang/String;)V", "sFileTypeMap", "Ljava/util/HashMap;", "Lcom/guagua/guagua/image/utils/MediaFileUtil$MediaFileType;", "sMimeTypeMap", "addFileType", "", "extension", "fileType", "mimeType", "getFileType", "path", "getFileTypeForMimeType", "isAudioFileType", "", "isImageFileType", "isPlayListFileType", "isVideoFileType", "MediaFileType", "imagepicker_release"})
public final class MediaFileUtil {
    @NotNull
    private static String sFileExtensions;
    private static final int FILE_TYPE_MP3 = 1;
    private static final int FILE_TYPE_M4A = 2;
    private static final int FILE_TYPE_WAV = 3;
    private static final int FILE_TYPE_AMR = 4;
    private static final int FILE_TYPE_AWB = 5;
    private static final int FILE_TYPE_WMA = 6;
    private static final int FILE_TYPE_OGG = 7;
    private static final int FIRST_AUDIO_FILE_TYPE = 1;
    private static final int LAST_AUDIO_FILE_TYPE = 7;
    private static final int FILE_TYPE_MID = 11;
    private static final int FILE_TYPE_SMF = 12;
    private static final int FILE_TYPE_IMY = 13;
    private static final int FIRST_MIDI_FILE_TYPE = 11;
    private static final int LAST_MIDI_FILE_TYPE = 13;
    private static final int FILE_TYPE_MP4 = 21;
    private static final int FILE_TYPE_M4V = 22;
    private static final int FILE_TYPE_3GPP = 23;
    private static final int FILE_TYPE_3GPP2 = 24;
    private static final int FILE_TYPE_WMV = 25;
    private static final int FIRST_VIDEO_FILE_TYPE = 21;
    private static final int LAST_VIDEO_FILE_TYPE = 25;
    private static final int FILE_TYPE_JPEG = 31;
    private static final int FILE_TYPE_GIF = 32;
    private static final int FILE_TYPE_PNG = 33;
    private static final int FILE_TYPE_BMP = 34;
    private static final int FILE_TYPE_WBMP = 35;
    private static final int FILE_TYPE_HEIC = 36;
    private static final int FIRST_IMAGE_FILE_TYPE = 31;
    private static final int LAST_IMAGE_FILE_TYPE = 36;
    private static final int FILE_TYPE_M3U = 41;
    private static final int FILE_TYPE_PLS = 42;
    private static final int FILE_TYPE_WPL = 43;
    private static final int FIRST_PLAYLIST_FILE_TYPE = 41;
    private static final int LAST_PLAYLIST_FILE_TYPE = 43;
    private static final HashMap<String, MediaFileType> sFileTypeMap;
    private static final HashMap<String, Integer> sMimeTypeMap;
    @NotNull
    private static final String UNKNOWN_STRING = "<unknown>";
    public static final MediaFileUtil INSTANCE;

    @NotNull
    public final String getSFileExtensions() {
        return sFileExtensions;
    }

    public final void setSFileExtensions(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        sFileExtensions = string2;
    }

    public final int getFILE_TYPE_MP3() {
        return FILE_TYPE_MP3;
    }

    public final int getFILE_TYPE_M4A() {
        return FILE_TYPE_M4A;
    }

    public final int getFILE_TYPE_WAV() {
        return FILE_TYPE_WAV;
    }

    public final int getFILE_TYPE_AMR() {
        return FILE_TYPE_AMR;
    }

    public final int getFILE_TYPE_AWB() {
        return FILE_TYPE_AWB;
    }

    public final int getFILE_TYPE_WMA() {
        return FILE_TYPE_WMA;
    }

    public final int getFILE_TYPE_OGG() {
        return FILE_TYPE_OGG;
    }

    public final int getFILE_TYPE_MID() {
        return FILE_TYPE_MID;
    }

    public final int getFILE_TYPE_SMF() {
        return FILE_TYPE_SMF;
    }

    public final int getFILE_TYPE_IMY() {
        return FILE_TYPE_IMY;
    }

    public final int getFILE_TYPE_MP4() {
        return FILE_TYPE_MP4;
    }

    public final int getFILE_TYPE_M4V() {
        return FILE_TYPE_M4V;
    }

    public final int getFILE_TYPE_3GPP() {
        return FILE_TYPE_3GPP;
    }

    public final int getFILE_TYPE_3GPP2() {
        return FILE_TYPE_3GPP2;
    }

    public final int getFILE_TYPE_WMV() {
        return FILE_TYPE_WMV;
    }

    public final int getFILE_TYPE_JPEG() {
        return FILE_TYPE_JPEG;
    }

    public final int getFILE_TYPE_GIF() {
        return FILE_TYPE_GIF;
    }

    public final int getFILE_TYPE_PNG() {
        return FILE_TYPE_PNG;
    }

    public final int getFILE_TYPE_BMP() {
        return FILE_TYPE_BMP;
    }

    public final int getFILE_TYPE_WBMP() {
        return FILE_TYPE_WBMP;
    }

    public final int getFILE_TYPE_HEIC() {
        return FILE_TYPE_HEIC;
    }

    public final int getFILE_TYPE_M3U() {
        return FILE_TYPE_M3U;
    }

    public final int getFILE_TYPE_PLS() {
        return FILE_TYPE_PLS;
    }

    public final int getFILE_TYPE_WPL() {
        return FILE_TYPE_WPL;
    }

    @NotNull
    public final String getUNKNOWN_STRING() {
        return UNKNOWN_STRING;
    }

    public final void addFileType(@NotNull String extension, int fileType, @NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        ((Map)sFileTypeMap).put(extension, new MediaFileType(fileType, mimeType));
        ((Map)sMimeTypeMap).put(mimeType, fileType);
    }

    public final boolean isAudioFileType(int fileType) {
        return fileType >= FIRST_AUDIO_FILE_TYPE && fileType <= LAST_AUDIO_FILE_TYPE || fileType >= FIRST_MIDI_FILE_TYPE && fileType <= LAST_MIDI_FILE_TYPE;
    }

    public final boolean isVideoFileType(int fileType) {
        return fileType >= FIRST_VIDEO_FILE_TYPE && fileType <= LAST_VIDEO_FILE_TYPE;
    }

    public final boolean isImageFileType(int fileType) {
        return fileType >= FIRST_IMAGE_FILE_TYPE && fileType <= LAST_IMAGE_FILE_TYPE;
    }

    public final boolean isPlayListFileType(int fileType) {
        return fileType >= FIRST_PLAYLIST_FILE_TYPE && fileType <= LAST_PLAYLIST_FILE_TYPE;
    }

    @Nullable
    public final MediaFileType getFileType(@NotNull String path) {
        MediaFileType mediaFileType;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        int lastDot = StringsKt.lastIndexOf$default((CharSequence)path, (String)".", (int)0, (boolean)false, (int)6, null);
        if (lastDot < 0) {
            mediaFileType = null;
        } else {
            String string2;
            String string3 = path;
            int n = lastDot + 1;
            HashMap<String, MediaFileType> hashMap = sFileTypeMap;
            boolean bl = false;
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            string3 = string2 = string4;
            n = 0;
            String string5 = string3;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
            string2 = string6;
            mediaFileType = hashMap.get(string2);
        }
        return mediaFileType;
    }

    public final boolean isVideoFileType(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        MediaFileType type = this.getFileType(path);
        return type != null ? this.isVideoFileType(type.getFileType()) : false;
    }

    public final boolean isAudioFileType(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        MediaFileType type = this.getFileType(path);
        return type != null ? this.isAudioFileType(type.getFileType()) : false;
    }

    public final int getFileTypeForMimeType(@NotNull String mimeType) {
        Integer value;
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        Integer n = value = sMimeTypeMap.get(mimeType);
        return n != null ? n : 0;
    }

    private MediaFileUtil() {
    }

    static {
        MediaFileUtil mediaFileUtil;
        INSTANCE = mediaFileUtil = new MediaFileUtil();
        FILE_TYPE_MP3 = 1;
        FILE_TYPE_M4A = 2;
        FILE_TYPE_WAV = 3;
        FILE_TYPE_AMR = 4;
        FILE_TYPE_AWB = 5;
        FILE_TYPE_WMA = 6;
        FILE_TYPE_OGG = 7;
        FIRST_AUDIO_FILE_TYPE = FILE_TYPE_MP3;
        LAST_AUDIO_FILE_TYPE = FILE_TYPE_OGG;
        FILE_TYPE_MID = 11;
        FILE_TYPE_SMF = 12;
        FILE_TYPE_IMY = 13;
        FIRST_MIDI_FILE_TYPE = FILE_TYPE_MID;
        LAST_MIDI_FILE_TYPE = FILE_TYPE_IMY;
        FILE_TYPE_MP4 = 21;
        FILE_TYPE_M4V = 22;
        FILE_TYPE_3GPP = 23;
        FILE_TYPE_3GPP2 = 24;
        FILE_TYPE_WMV = 25;
        FIRST_VIDEO_FILE_TYPE = FILE_TYPE_MP4;
        LAST_VIDEO_FILE_TYPE = FILE_TYPE_WMV;
        FILE_TYPE_JPEG = 31;
        FILE_TYPE_GIF = 32;
        FILE_TYPE_PNG = 33;
        FILE_TYPE_BMP = 34;
        FILE_TYPE_WBMP = 35;
        FILE_TYPE_HEIC = 36;
        FIRST_IMAGE_FILE_TYPE = FILE_TYPE_JPEG;
        LAST_IMAGE_FILE_TYPE = FILE_TYPE_HEIC;
        FILE_TYPE_M3U = 41;
        FILE_TYPE_PLS = 42;
        FILE_TYPE_WPL = 43;
        FIRST_PLAYLIST_FILE_TYPE = FILE_TYPE_M3U;
        LAST_PLAYLIST_FILE_TYPE = FILE_TYPE_WPL;
        sFileTypeMap = new HashMap();
        sMimeTypeMap = new HashMap();
        UNKNOWN_STRING = UNKNOWN_STRING;
        mediaFileUtil.addFileType("MP3", FILE_TYPE_MP3, "audio/mpeg");
        mediaFileUtil.addFileType("M4A", FILE_TYPE_M4A, "audio/mp4");
        mediaFileUtil.addFileType("WAV", FILE_TYPE_WAV, "audio/x-wav");
        mediaFileUtil.addFileType("AMR", FILE_TYPE_AMR, "audio/amr");
        mediaFileUtil.addFileType("AWB", FILE_TYPE_AWB, "audio/amr-wb");
        mediaFileUtil.addFileType("WMA", FILE_TYPE_WMA, "audio/x-ms-wma");
        mediaFileUtil.addFileType("OGG", FILE_TYPE_OGG, "application/ogg");
        mediaFileUtil.addFileType("MID", FILE_TYPE_MID, "audio/midi");
        mediaFileUtil.addFileType("XMF", FILE_TYPE_MID, "audio/midi");
        mediaFileUtil.addFileType("RTTTL", FILE_TYPE_MID, "audio/midi");
        mediaFileUtil.addFileType("SMF", FILE_TYPE_SMF, "audio/sp-midi");
        mediaFileUtil.addFileType("IMY", FILE_TYPE_IMY, "audio/imelody");
        mediaFileUtil.addFileType("MP4", FILE_TYPE_MP4, "video/mp4");
        mediaFileUtil.addFileType("M4V", FILE_TYPE_M4V, "video/mp4");
        mediaFileUtil.addFileType("3GP", FILE_TYPE_3GPP, "video/3gpp");
        mediaFileUtil.addFileType("3GPP", FILE_TYPE_3GPP, "video/3gpp");
        mediaFileUtil.addFileType("3G2", FILE_TYPE_3GPP2, "video/3gpp2");
        mediaFileUtil.addFileType("3GPP2", FILE_TYPE_3GPP2, "video/3gpp2");
        mediaFileUtil.addFileType("WMV", FILE_TYPE_WMV, "video/x-ms-wmv");
        mediaFileUtil.addFileType("JPG", FILE_TYPE_JPEG, "image/jpeg");
        mediaFileUtil.addFileType("JPEG", FILE_TYPE_JPEG, "image/jpeg");
        mediaFileUtil.addFileType("GIF", FILE_TYPE_GIF, "image/gif");
        mediaFileUtil.addFileType("PNG", FILE_TYPE_PNG, "image/png");
        mediaFileUtil.addFileType("heic", FILE_TYPE_HEIC, "image/heic");
        mediaFileUtil.addFileType("BMP", FILE_TYPE_BMP, "image/x-ms-bmp");
        mediaFileUtil.addFileType("WBMP", FILE_TYPE_WBMP, "image/vnd.wap.wbmp");
        mediaFileUtil.addFileType("M3U", FILE_TYPE_M3U, "audio/x-mpegurl");
        mediaFileUtil.addFileType("PLS", FILE_TYPE_PLS, "audio/x-scpls");
        mediaFileUtil.addFileType("WPL", FILE_TYPE_WPL, "application/vnd.ms-wpl");
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = sFileTypeMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(iterator.next());
        }
        String string2 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
        sFileExtensions = string2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/guagua/guagua/image/utils/MediaFileUtil$MediaFileType;", "", "fileType", "", "mimeType", "", "(ILjava/lang/String;)V", "getFileType", "()I", "setFileType", "(I)V", "getMimeType", "()Ljava/lang/String;", "setMimeType", "(Ljava/lang/String;)V", "imagepicker_release"})
    public static final class MediaFileType {
        private int fileType;
        @NotNull
        private String mimeType;

        public final int getFileType() {
            return this.fileType;
        }

        public final void setFileType(int n) {
            this.fileType = n;
        }

        @NotNull
        public final String getMimeType() {
            return this.mimeType;
        }

        public final void setMimeType(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
            this.mimeType = string2;
        }

        public MediaFileType(int fileType, @NotNull String mimeType) {
            Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
            this.fileType = fileType;
            this.mimeType = mimeType;
        }
    }
}

