/*
 * Decompiled with CFR 0.152.
 */
package com.guagua.guagua.image.utils;

import android.view.View;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u001f\u0010\u0018\u001a\u00020\u00162\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001a\"\u00020\u000e\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u0018\u001a\u00020\u00162\n\u0010\u001c\u001a\u00020\u001d\"\u00020\u0004R&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/guagua/guagua/image/utils/FastClickChecker;", "", "()V", "timeSpan", "", "(I)V", "idTimeHashMap", "Ljava/util/HashMap;", "", "getIdTimeHashMap", "()Ljava/util/HashMap;", "setIdTimeHashMap", "(Ljava/util/HashMap;)V", "viewTimeHashMap", "Landroid/view/View;", "getViewTimeHashMap", "setViewTimeHashMap", "isFastClick", "", "view", "viewId", "setTimeSpan", "", "span", "setView", "views", "", "([Landroid/view/View;)V", "viewIds", "", "imagepicker_release"})
public final class FastClickChecker {
    @NotNull
    private HashMap<View, Long> viewTimeHashMap = new HashMap();
    @NotNull
    private HashMap<Integer, Long> idTimeHashMap = new HashMap();
    private int timeSpan = 500;

    @NotNull
    public final HashMap<View, Long> getViewTimeHashMap() {
        return this.viewTimeHashMap;
    }

    public final void setViewTimeHashMap(@NotNull HashMap<View, Long> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.viewTimeHashMap = hashMap;
    }

    @NotNull
    public final HashMap<Integer, Long> getIdTimeHashMap() {
        return this.idTimeHashMap;
    }

    public final void setIdTimeHashMap(@NotNull HashMap<Integer, Long> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.idTimeHashMap = hashMap;
    }

    public final void setView(int ... viewIds) {
        Intrinsics.checkParameterIsNotNull((Object)viewIds, (String)"viewIds");
        for (int id2 : viewIds) {
            ((Map)this.idTimeHashMap).put(id2, 0L);
        }
    }

    public final void setView(View ... views) {
        Intrinsics.checkParameterIsNotNull((Object)views, (String)"views");
        for (View v : views) {
            ((Map)this.viewTimeHashMap).put(v, 0L);
        }
    }

    public final boolean isFastClick(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (this.viewTimeHashMap.containsKey(view)) {
            long span;
            Long lastClickTime = this.viewTimeHashMap.get(view);
            long time = System.currentTimeMillis();
            Long l = lastClickTime;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            if (0L < (span = time - l) && span < (long)this.timeSpan) {
                return true;
            }
            ((Map)this.viewTimeHashMap).put(view, time);
        }
        return false;
    }

    public final boolean isFastClick(int viewId) {
        if (this.idTimeHashMap.containsKey(viewId)) {
            long span;
            Long lastClickTime = this.idTimeHashMap.get(viewId);
            long time = System.currentTimeMillis();
            Long l = lastClickTime;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            if (0L < (span = time - l) && span < (long)this.timeSpan) {
                return true;
            }
            ((Map)this.idTimeHashMap).put(viewId, time);
        }
        return false;
    }

    public final void setTimeSpan(int span) {
        this.timeSpan = span;
    }

    public FastClickChecker() {
    }

    public FastClickChecker(int timeSpan) {
        this.timeSpan = timeSpan;
    }
}

