package com.guagua.guagua.image.view

import android.graphics.Canvas
import android.graphics.Rect
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 18:26
 * Version: 1.0.0
 * Description: 列表divider适配器
 * History:
 * <author> <time> <version> <desc>
 */
class SpaceItemDecoration//leftRight为横向间的距离 topBottom为纵向间距离
    (private val leftRight: Int, private val topBottom: Int) : RecyclerView.ItemDecoration() {

    override fun onDraw(c: Canvas, parent: RecyclerView, state: RecyclerView.State) {
        super.onDraw(c, parent, state)
    }

    override fun getItemOffsets(outRect: Rect, view: View, parent: RecyclerView, state: RecyclerView.State) {
        val layoutManager = parent.getLayoutManager() as LinearLayoutManager
        //竖直方向的
        if (layoutManager.getOrientation() === LinearLayoutManager.VERTICAL) {
            //最后一项需要 bottom
            if (parent.getChildAdapterPosition(view) === layoutManager.getItemCount() - 1) {
                outRect.bottom = topBottom
            }
            outRect.top = topBottom
            outRect.left = leftRight
            outRect.right = leftRight
        } else {
            //最后一项需要right
            if (parent.getChildAdapterPosition(view) === layoutManager.getItemCount() - 1) {
                outRect.right = leftRight
            }
            outRect.top = topBottom
            outRect.left = leftRight
            outRect.bottom = 0
        }
    }


}
