package com.guagua.guagua.image.task

import android.content.Context
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.listener.MediaLoadCallback
import com.guagua.guagua.image.loader.ImageScanner
import com.guagua.guagua.image.loader.MediaHandler
import com.guagua.guagua.image.loader.VideoScanner
import java.util.ArrayList

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 20:02
 * Version: 1.0.0
 * Description: 图片扫描器
 * History:
 * <author> <time> <version> <desc>
 */
class MediaLoadTask(context: Context, mediaLoadCallback: MediaLoadCallback): Runnable {

    private val mContext: Context
    private val mImageScanner: ImageScanner?
    private val mVideoScanner: VideoScanner?
    private val mMediaLoadCallback: MediaLoadCallback?

    init {
        mContext = context
        mImageScanner = ImageScanner(mContext)
        mVideoScanner = VideoScanner(mContext)
        mMediaLoadCallback = mediaLoadCallback
    }

    override fun run() {
        //存放所有照片
        var imageFileList = ArrayList<MediaFile>()
        //存放所有视频
        var videoFileList = ArrayList<MediaFile>()

        mImageScanner?.let { imageFileList = it.queryMedia() }
        mVideoScanner?.let { videoFileList = it.queryMedia() }

        mMediaLoadCallback?.loadMediaSuccess(MediaHandler.getMediaFolder(mContext, imageFileList, videoFileList))
    }
}