package com.guagua.guagua.image.loader

import android.content.Context
import android.database.Cursor
import android.net.Uri
import android.util.Log
import com.guagua.guagua.image.data.MediaFile
import java.util.ArrayList

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 20:11
 * Version: 1.0.0
 * Description: 扫描基础类
 * History:
 * <author> <time> <version> <desc>
 */
abstract class AbsMediaScanner<T>(val context: Context) {
    /**
     * 查询URI
     *
     * @return
     */
    protected abstract fun getScanUri(): Uri

    /**
     * 查询列名
     *
     * @return
     */
    protected abstract fun getProjection(): Array<String>

    /**
     * 查询条件
     *
     * @return
     */
    protected abstract fun getSelection(): String?

    /**
     * 查询条件值
     *
     * @return
     */
    protected abstract fun getSelectionArgs(): Array<String>?

    /**
     * 查询排序
     *
     * @return
     */
    protected abstract fun getOrder(): String

    /**
     * 对外暴露游标，让开发者灵活构建对象
     *
     * @param cursor
     * @return
     */
    protected abstract fun parse(cursor: Cursor): T

    private var mContext: Context? = null

    init {
        this.mContext = context
    }

    /**
     * 根据查询条件进行媒体库查询，隐藏查询细节，让开发者更专注业务
     *
     * @return
     */
    fun queryMedia(): ArrayList<T> {
        val list = ArrayList<T>()
        val contentResolver = mContext?.contentResolver
        val cursor = contentResolver?.query(
            getScanUri(),
            getProjection(),
            getSelection(),
            getSelectionArgs(),
            getOrder()
        )
        if (cursor != null) {
            while (cursor.moveToNext()) {
                val t = parse(cursor)
                list.add(t)
                if (t is MediaFile) {
                    Log.e(
                        "AbsMediaScanner",
                        (t as MediaFile).folderName + "   " + (t as MediaFile).path
                    )
                }
            }
            cursor.close()
        }
        return list
    }
}