package com.guagua.guagua.image.activity

import android.content.Intent
import android.content.pm.PackageManager
import android.view.View
import android.view.WindowManager
import androidx.core.content.FileProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.viewpager.widget.ViewPager
import com.guagua.guagua.image.manager.SelectionManager
import com.guagua.guagua.image.R
import com.guagua.guagua.image.adapter.ImageSelectedAdapter
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.listener.OnImageClick
import com.guagua.guagua.image.manager.ConfigManager
import com.guagua.guagua.image.provider.ImagePickerProvider
import com.guagua.guagua.image.utils.DataUtil
import com.guagua.guagua.image.utils.FileSizeUtil
import com.guagua.guagua.image.utils.MediaFileUtil
import com.guagua.guagua.image.view.ImagePreViewAdapter
import com.guagua.guagua.image.view.SpaceItemDecoration
import kotlinx.android.synthetic.main.activity_pre.*
import java.io.File

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 15:24
 * Version: 1.0.0
 * Description: 列表图片选择页面
 * History:
 * <author> <time> <version> <desc>
 */
class ImagePreActivity: BaseActivity() {

    private var mMediaFileList: List<MediaFile>? = null
    private var mPosition = 0
    private var isShowLayout = true
    private var imageSelectedAdapter: ImageSelectedAdapter? = null
    private var mImagePreViewAdapter: ImagePreViewAdapter? = null

    companion object {
        val IMAGE_POSITION = "imagePosition"
    }

    override fun bindLayout(): Int {
        window.addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN)
        return R.layout.activity_pre
    }

    override fun initConfig() {
    }

    override fun initView() {
    }

    override fun initListener() {
        ivActionBarBack1.setOnClickListener { finish() }
        tvIndicator.setOnClickListener { finish() }

        vpMainPreImage.addOnPageChangeListener(object : ViewPager.OnPageChangeListener {
            override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {}

            override fun onPageSelected(position: Int) {
                tvIndicator.text = String.format("%d/%d", position + 1, mMediaFileList?.size)
                setIvPlayShow(mMediaFileList?.get(position)!!)
                updateSelectButton(mMediaFileList?.get(position)!!.path)
                mPosition = position
            }

            override fun onPageScrollStateChanged(state: Int) {

            }
        })

        ivItemCheck.setOnClickListener{ selectImage() }

        tvItemCheck.setOnClickListener{ selectImage() }

        tvSendImages.setOnClickListener{
            setResult(RESULT_OK, Intent())
            finish()
        }

        ivMainPlay.setOnClickListener {
            //实现播放视频的跳转逻辑(调用原生视频播放器)
            val intent = Intent(Intent.ACTION_VIEW)
            val uri = FileProvider.getUriForFile(
                this@ImagePreActivity,
                ImagePickerProvider.getFileProviderName(this@ImagePreActivity),
                File(mMediaFileList?.get(vpMainPreImage.currentItem)!!.path)
            )
            intent.setDataAndType(uri, "video/*")
            //给所有符合跳转条件的应用授权
            val resInfoList = packageManager
                .queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY)
            for (resolveInfo in resInfoList) {
                val packageName = resolveInfo.activityInfo.packageName
                grantUriPermission(
                    packageName, uri,
                    Intent.FLAG_GRANT_READ_URI_PERMISSION or Intent.FLAG_GRANT_WRITE_URI_PERMISSION
                )
            }
            startActivity(intent)
        }
        if (SelectionManager.getSelectPaths().isNotEmpty()) {
            rvGallery.visibility = View.VISIBLE
        }
    }

    override fun getData() {
        mMediaFileList = DataUtil.instance?.getMediaData()
        mPosition = intent.getIntExtra(IMAGE_POSITION, 0)
        tvIndicator.text = String.format("%d/%d", mPosition + 1, mMediaFileList?.size)

        imageSelectedAdapter = ImageSelectedAdapter(this)
        val manager = LinearLayoutManager(this)
        manager.orientation = LinearLayoutManager.HORIZONTAL
        rvGallery.layoutManager = manager
        rvGallery.adapter = imageSelectedAdapter
        rvGallery.addItemDecoration(SpaceItemDecoration(10, 10))
        imageSelectedAdapter?.setOnItemClick(object : ImageSelectedAdapter.OnItemClick {

            override fun onClick(path: String) {
                var isHad = false
                for (i in mMediaFileList!!.indices) {
                    if (path == mMediaFileList?.get(i)!!.path) {
                        mPosition = i
                        vpMainPreImage.setCurrentItem(i, false)
                        isHad = true
                        break
                    }
                }
                if (!isHad) {
                    mPosition = 0
                    vpMainPreImage.setCurrentItem(0, false)
                }
            }
        })

        mImagePreViewAdapter = ImagePreViewAdapter(this, mMediaFileList)
        vpMainPreImage.adapter = mImagePreViewAdapter
        vpMainPreImage.currentItem = mPosition
        mImagePreViewAdapter?.setOnImageClickListener(object : OnImageClick {
            override fun onClick() {
                if (!isShowLayout) {
                    ivActionBarBack1.visibility = View.INVISIBLE
                    rvGallery.visibility = View.INVISIBLE
                    rlMainBottom.visibility = View.INVISIBLE
                    rvTop.visibility = View.INVISIBLE
                } else {
                    if (SelectionManager.getSelectPaths().size > 0) {
                        rvGallery.visibility = View.VISIBLE
                    }
                    ivActionBarBack1.visibility = View.VISIBLE
                    rlMainBottom.visibility = View.VISIBLE
                    rvTop.visibility = View.VISIBLE
                }
                isShowLayout = !isShowLayout
            }
        })
        //更新当前页面状态
        setIvPlayShow(mMediaFileList?.get(mPosition)!!)
        updateSelectButton(mMediaFileList?.get(mPosition)!!.path)
        updateCommitButton()
        updateGallery()
    }


    private fun selectImage() {
        //如果是单类型选取，判断添加类型是否满足（照片视频不能共存）
        if (ConfigManager.isSingleType()) {
            val selectPathList = SelectionManager.getSelectPaths()
            if (selectPathList.isNotEmpty()) {
                //判断选中集合中第一项是否为视频
                if (!SelectionManager.isCanAddSelectionPaths(mMediaFileList?.get(vpMainPreImage.currentItem)!!.path, selectPathList[0])) {
                    //类型不同
                    showMessage(getString(R.string.single_type_choose))
                    return
                }
            }
        }

        if (MediaFileUtil.isVideoFileType(mMediaFileList?.get(vpMainPreImage.currentItem)!!.path)) {
            if (!mMediaFileList?.get(vpMainPreImage.currentItem)!!.path.toLowerCase().endsWith(getString(R.string.support_video_type))) {
                showMessage(R.string.support_video_type_msg)
                return
            }
            if (mMediaFileList?.get(vpMainPreImage.currentItem)!!.duration === 0L) {
                showMessage(R.string.video_empty_msg)
                return
            }
            if (mMediaFileList?.get(vpMainPreImage.currentItem)!!.duration > FileSizeUtil.SIZETYPE_LIMIT_DURATION) {
                showMessage(R.string.video_too_long_msg)
                return
            }
            if (FileSizeUtil.getFileOrFilesSize(mMediaFileList?.get(vpMainPreImage.currentItem)!!.path, FileSizeUtil.SIZETYPE_MB) > FileSizeUtil.SIZETYPE_LIMIT_SIZE) {
                showMessage(R.string.video_too_large_msg)
                return
            }
        }

        val addSuccess = SelectionManager.addImageDurationToSelectList(
            mMediaFileList?.get(vpMainPreImage.currentItem)!!.path,
            mMediaFileList?.get(vpMainPreImage.currentItem)!!.duration
        )
        if (addSuccess) {
            updateSelectButton(mMediaFileList?.get(vpMainPreImage.currentItem)!!.path)
            updateCommitButton()
            imageSelectedAdapter?.notifyDataSetChanged()
        } else {
            showMessage(String.format(getString(R.string.select_image_max), ConfigManager.getMaxCount()))
        }
        updateGallery()
    }

    private fun updateGallery() {
        if (SelectionManager.getSelectPaths().size > 0) {
            rvGallery.visibility = View.VISIBLE
        } else {
            rvGallery.visibility = View.INVISIBLE
        }
    }

    /**
     * 更新确认按钮状态
     */
    private fun updateCommitButton() {
        val mMaxCount = SelectionManager.getMaxCount()
        //改变确定按钮UI
        val selectCount = SelectionManager.getSelectPaths().size
        if (selectCount == 0) {
            tvSendImages.isEnabled = false
            tvSendImages.text = getString(R.string.confirm)
            tvSendImages.setBackgroundResource(R.drawable.image_send_normal)
            tvImagesCount.text = "选择 0 张"
            return
        }
        if (selectCount < mMaxCount) {
            tvSendImages.isEnabled = true
            tvSendImages.setBackgroundResource(R.drawable.image_send_selected)
            tvSendImages.text = getString(R.string.confirm)
            tvImagesCount.text = "选择 $selectCount 张"
            return
        }
        if (selectCount == mMaxCount) {
            tvSendImages.isEnabled = true
            tvSendImages.setBackgroundResource(R.drawable.image_send_selected)
            tvSendImages.text = getString(R.string.confirm)
            tvImagesCount.text = "选择 $selectCount 张"
            return
        }
    }

    /**
     * 更新选择按钮状态
     */
    private fun updateSelectButton(imagePath: String) {
        val isSelect = SelectionManager.isImageSelect(imagePath)
        if (isSelect) {
            ivItemCheck.visibility = View.GONE
            tvItemCheck.visibility = View.VISIBLE
            tvItemCheck.text = SelectionManager.indexOf(imagePath).toString()
        } else {
            ivItemCheck.visibility = View.VISIBLE
            tvItemCheck.visibility = View.GONE
            tvItemCheck.text = ""
        }
        imageSelectedAdapter?.updateView(imagePath, isSelect)
    }

    /**
     * 设置是否显示视频播放按钮
     *
     * @param mediaFile         显示/隐藏播放按钮
     */
    private fun setIvPlayShow(mediaFile: MediaFile) {
        if (mediaFile.duration > 0) {
            ivMainPlay.visibility = View.VISIBLE
        } else {
            ivMainPlay.visibility = View.GONE
        }
    }
}