/*
 * Decompiled with CFR 0.152.
 */
package com.guagua.guagua.image.utils;

import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014J\u0016\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/guagua/guagua/image/utils/FileSizeUtil;", "", "()V", "SIZETYPE_B", "", "getSIZETYPE_B", "()I", "SIZETYPE_GB", "getSIZETYPE_GB", "SIZETYPE_KB", "getSIZETYPE_KB", "SIZETYPE_LIMIT_DURATION", "", "getSIZETYPE_LIMIT_DURATION", "()J", "SIZETYPE_LIMIT_SIZE", "getSIZETYPE_LIMIT_SIZE", "SIZETYPE_MB", "getSIZETYPE_MB", "FormetFileSize", "", "fileS", "", "sizeType", "getAutoFileOrFilesSize", "filePath", "getFileOrFilesSize", "getFileSize", "file", "Ljava/io/File;", "getFileSizes", "f", "imagepicker_release"})
public final class FileSizeUtil {
    private static final int SIZETYPE_B = 1;
    private static final int SIZETYPE_KB = 2;
    private static final int SIZETYPE_MB = 3;
    private static final int SIZETYPE_GB = 4;
    private static final long SIZETYPE_LIMIT_DURATION = 120000L;
    private static final long SIZETYPE_LIMIT_SIZE = 20L;
    public static final FileSizeUtil INSTANCE;

    public final int getSIZETYPE_B() {
        return SIZETYPE_B;
    }

    public final int getSIZETYPE_KB() {
        return SIZETYPE_KB;
    }

    public final int getSIZETYPE_MB() {
        return SIZETYPE_MB;
    }

    public final int getSIZETYPE_GB() {
        return SIZETYPE_GB;
    }

    public final long getSIZETYPE_LIMIT_DURATION() {
        return SIZETYPE_LIMIT_DURATION;
    }

    public final long getSIZETYPE_LIMIT_SIZE() {
        return SIZETYPE_LIMIT_SIZE;
    }

    public final double getFileOrFilesSize(@NotNull String filePath, int sizeType) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? this.getFileSizes(file) : this.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f", (String)"\u83b7\u53d6\u5931\u8d25!");
        }
        return this.FormetFileSize(blockSize, sizeType);
    }

    @NotNull
    public final String getAutoFileOrFilesSize(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? this.getFileSizes(file) : this.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f", (String)"\u83b7\u53d6\u5931\u8d25!");
        }
        return this.FormetFileSize(blockSize);
    }

    private final long getFileSize(File file) throws Exception {
        long size = 0L;
        if (file.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            size = fis.available();
        } else {
            file.createNewFile();
            Log.e((String)"\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    private final long getFileSizes(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        int n = 0;
        if (flist == null) {
            Intrinsics.throwNpe();
        }
        int n2 = flist.length;
        while (n < n2) {
            void i;
            File file = flist[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"flist[i]");
            if (file.isDirectory()) {
                File file2 = flist[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"flist[i]");
                size += this.getFileSizes(file2);
            } else {
                File file3 = flist[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"flist[i]");
                size += this.getFileSize(file3);
            }
            ++i;
        }
        return size;
    }

    private final String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        fileSizeString = fileS < (long)1024 ? df.format((double)fileS) + "B" : (fileS < (long)0x100000 ? df.format((double)fileS / (double)1024) + "KB" : (fileS < (long)0x40000000 ? df.format((double)fileS / (double)0x100000) + "MB" : df.format((double)fileS / (double)0x40000000) + "GB"));
        return fileSizeString;
    }

    private final double FormetFileSize(long fileS, int sizeType) {
        DecimalFormat df = new DecimalFormat("#.00");
        double fileSizeLong = 0.0;
        int n = sizeType;
        if (n == SIZETYPE_B) {
            Double d = Double.valueOf(df.format((double)fileS));
            Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"java.lang.Double.valueOf\u2026format(fileS.toDouble()))");
            fileSizeLong = d;
        } else if (n == SIZETYPE_KB) {
            Double d = Double.valueOf(df.format((double)fileS / (double)1024));
            Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"java.lang.Double.valueOf\u2026fileS.toDouble() / 1024))");
            fileSizeLong = d;
        } else if (n == SIZETYPE_MB) {
            Double d = Double.valueOf(df.format((double)fileS / (double)0x100000));
            Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"java.lang.Double.valueOf\u2026eS.toDouble() / 1048576))");
            fileSizeLong = d;
        } else if (n == SIZETYPE_GB) {
            Double d = Double.valueOf(df.format((double)fileS / (double)0x40000000));
            Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"java.lang.Double.valueOf\u20261073741824)\n            )");
            fileSizeLong = d;
        }
        return fileSizeLong;
    }

    private FileSizeUtil() {
    }

    static {
        FileSizeUtil fileSizeUtil;
        INSTANCE = fileSizeUtil = new FileSizeUtil();
        SIZETYPE_B = 1;
        SIZETYPE_KB = 2;
        SIZETYPE_MB = 3;
        SIZETYPE_GB = 4;
        SIZETYPE_LIMIT_DURATION = 120000;
        SIZETYPE_LIMIT_SIZE = 20L;
    }
}

