/*
 * Decompiled with CFR 0.152.
 */
package com.guagua.guagua.image.loader;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import com.guagua.guagua.image.data.MediaFile;
import com.guagua.guagua.image.loader.AbsMediaScanner;
import com.guagua.guagua.image.manager.ConfigManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0014\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u0007H\u0014J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0014\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/guagua/guagua/image/loader/ImageScanner;", "Lcom/guagua/guagua/image/loader/AbsMediaScanner;", "Lcom/guagua/guagua/image/data/MediaFile;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getOrder", "", "getProjection", "", "()[Ljava/lang/String;", "getScanUri", "Landroid/net/Uri;", "getSelection", "getSelectionArgs", "parse", "cursor", "Landroid/database/Cursor;", "imagepicker_release"})
public final class ImageScanner
extends AbsMediaScanner<MediaFile> {
    @Override
    @NotNull
    protected Uri getScanUri() {
        Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"MediaStore.Images.Media.EXTERNAL_CONTENT_URI");
        return uri;
    }

    @Override
    @NotNull
    protected String[] getProjection() {
        return new String[]{"_data", "mime_type", "bucket_id", "bucket_display_name", "datetaken", "date_added"};
    }

    @Override
    @NotNull
    protected String getSelection() {
        return ConfigManager.INSTANCE.isFilterGif() ? "mime_type=? or mime_type=? or mime_type=?" : "mime_type=? or mime_type=? or mime_type=? or mime_type=?";
    }

    @Override
    @NotNull
    protected String[] getSelectionArgs() {
        String[] stringArray;
        if (ConfigManager.INSTANCE.isFilterGif()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "image/jpeg";
            stringArray2[1] = "image/png";
            stringArray = stringArray2;
            stringArray2[2] = "image/heic";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "image/jpeg";
            stringArray3[1] = "image/png";
            stringArray3[2] = "image/heic";
            stringArray = stringArray3;
            stringArray3[3] = "image/gif";
        }
        return stringArray;
    }

    @Override
    @NotNull
    protected String getOrder() {
        return "date_added desc";
    }

    @Override
    @NotNull
    protected MediaFile parse(@NotNull Cursor cursor) {
        Intrinsics.checkParameterIsNotNull((Object)cursor, (String)"cursor");
        String path = cursor.getString(cursor.getColumnIndex("_data"));
        String mime = cursor.getString(cursor.getColumnIndex("mime_type"));
        int folderId = cursor.getInt(cursor.getColumnIndex("bucket_id"));
        String folderName = cursor.getString(cursor.getColumnIndex("bucket_display_name"));
        long dateToken = cursor.getLong(cursor.getColumnIndex("datetaken"));
        String dateAdded = cursor.getString(cursor.getColumnIndex("date_added"));
        String string2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        return new MediaFile(string2, mime, folderId, folderName, 0L, dateToken, dateAdded);
    }

    public ImageScanner(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }
}

