package com.guagua.guagua.image.utils

import android.Manifest
import android.content.Context
import android.content.pm.PackageManager
import androidx.core.content.ContextCompat
import com.guagua.guagua.image.manager.ConfigManager

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 15:54
 * Version: 1.0.0
 * Description: 权限检查类
 * History:
 * <author> <time> <version> <desc>
 */

object PermissionUtil {

    /**
     * 权限检查
     *
     * @param context
     * @return
     */
    fun checkPermission(context: Context): Boolean {
        return if (ConfigManager.isShowCamera()) {
            ContextCompat.checkSelfPermission(
                context,
                Manifest.permission.READ_EXTERNAL_STORAGE
            ) === PackageManager.PERMISSION_GRANTED && ContextCompat.checkSelfPermission(
                context,
                Manifest.permission.CAMERA
            ) === PackageManager.PERMISSION_GRANTED
        } else {
            ContextCompat.checkSelfPermission(
                context,
                Manifest.permission.READ_EXTERNAL_STORAGE
            ) === PackageManager.PERMISSION_GRANTED
        }
    }
}