package com.guagua.guagua.image.loader

import android.content.Context
import android.util.Log
import com.guagua.guagua.image.R
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.data.MediaFolder
import java.util.*

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/28 11:29
 * Version: 1.0.0
 * Description: 媒体处理类（对扫描出来的图片、视频做对应聚类处理）
 * History:
 * <author> <time> <version> <desc>
 */
class MediaHandler {
    companion object {
        val ALL_MEDIA_FOLDER = -1//全部媒体
        val ALL_VIDEO_FOLDER = -2//全部视频
        /**
         * 对查询到的图片进行聚类（相册分类）
         *
         * @param context
         * @param imageFileList
         * @return
         */
        fun getImageFolder(context: Context, imageFileList: ArrayList<MediaFile>): MutableList<MediaFolder> {
            return getMediaFolder(context, imageFileList, null)
        }


        /**
         * 对查询到的视频进行聚类（相册分类）
         *
         * @param context
         * @param imageFileList
         * @return
         */
        fun getVideoFolder(context: Context, imageFileList: ArrayList<MediaFile>): MutableList<MediaFolder> {
            return getMediaFolder(context, null, imageFileList)
        }

        /**
         * 对查询到的图片和视频进行聚类（相册分类）
         *
         * @param context
         * @param imageFileList
         * @param videoFileList
         * @return
         */
        fun getMediaFolder(context: Context, imageFileList: ArrayList<MediaFile>?, videoFileList: ArrayList<MediaFile>?): MutableList<MediaFolder> {

            //根据媒体所在文件夹Id进行聚类（相册）
            val mediaFolderMap = HashMap<Int, MediaFolder>()

            imageFileList?.forEach { Log.e("MediaHandler", "data === " + it.toString()) }
            videoFileList?.forEach { Log.e("MediaHandler", "data === " + it.toString()) }

            //全部图片、视频文件
            val mediaFileList = ArrayList<MediaFile>()
            if (imageFileList != null) {
                mediaFileList.addAll(imageFileList)
            }
            if (videoFileList != null) {
                mediaFileList.addAll(videoFileList)
            }

            //对媒体数据进行排序
            Collections.sort(mediaFileList) { o1, o2 ->
                if (o1.dateAdded!!.toLong() > o2.dateAdded!!.toLong()) {
                    -1
                } else if (o1.dateAdded!!.toLong() < o2.dateAdded!!.toLong()) {
                    1
                } else {
                    0
                }
            }

            //全部图片或视频
            if (!mediaFileList.isEmpty()) {
                val allMediaFolder = MediaFolder(
                    ALL_MEDIA_FOLDER,
                    context.getString(R.string.all_media),
                    mediaFileList[0].path,
                    mediaFileList
                )
                mediaFolderMap[ALL_MEDIA_FOLDER] = allMediaFolder
            }

            //全部视频
            if (videoFileList != null && !videoFileList.isEmpty()) {
                val allVideoFolder = MediaFolder(
                    ALL_VIDEO_FOLDER,
                    context.getString(R.string.all_video),
                    videoFileList[0].path,
                    videoFileList
                )
                mediaFolderMap[ALL_VIDEO_FOLDER] = allVideoFolder
            }

            //对图片进行文件夹分类
            if (imageFileList != null && !imageFileList.isEmpty()) {
                val size = imageFileList.size
                //添加其他的图片文件夹
                for (i in 0 until size) {
                    val mediaFile = imageFileList[i]
                    val imageFolderId = mediaFile.folderId
                    var mediaFolder: MediaFolder? = mediaFolderMap[imageFolderId]
                    if (mediaFolder == null) {
                        mediaFolder = MediaFolder(
                            imageFolderId!!,
                            mediaFile.folderName,
                            mediaFile.path,
                            ArrayList()
                        )
                    }
                    val imageList = mediaFolder.mediaFileList
                    imageList?.add(mediaFile)
                    mediaFolder.mediaFileList = imageList
                    mediaFolderMap[imageFolderId!!] = mediaFolder
                }
            }

            //整理聚类数据
            val mediaFolderList = ArrayList<MediaFolder>()
            for (folderId in mediaFolderMap.keys) {
                mediaFolderList.add(mediaFolderMap[folderId]!!)
            }

            //按照图片文件夹的数量排序
            Collections.sort(
                mediaFolderList
            ) { o1, o2 ->
                if (o1.mediaFileList!!.size > o2.mediaFileList!!.size) {
                    -1
                } else if (o1.mediaFileList!!.size < o2.mediaFileList!!.size) {
                    1
                } else {
                    0
                }
            }


            return mediaFolderList
        }
    }
}