package com.guagua.guagua.image.loader

import android.content.Context
import android.database.Cursor
import android.net.Uri
import android.provider.MediaStore
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.manager.ConfigManager

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 20:18
 * Version: 1.0.0
 * Description: 图片扫描类
 * History:
 * <author> <time> <version> <desc>
 */
class ImageScanner(context: Context): AbsMediaScanner<MediaFile>(context) {

    override fun getScanUri(): Uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI

    override fun getProjection(): Array<String> = arrayOf(
        MediaStore.Images.Media.DATA,
        MediaStore.Images.Media.MIME_TYPE,
        MediaStore.Images.Media.BUCKET_ID,
        MediaStore.Images.Media.BUCKET_DISPLAY_NAME,
        MediaStore.Images.Media.DATE_TAKEN,
        MediaStore.Images.Media.DATE_ADDED
    )

    override fun getSelection(): String {
        return if (ConfigManager.isFilterGif()) {
            //过滤GIF
            MediaStore.Images.Media.MIME_TYPE + "=? or " + MediaStore.Images.Media.MIME_TYPE + "=? or " + MediaStore.Images.Media.MIME_TYPE + "=?"
        } else MediaStore.Images.Media.MIME_TYPE + "=? or " + MediaStore.Images.Media.MIME_TYPE + "=?" + " or " + MediaStore.Images.Media.MIME_TYPE + "=? or " + MediaStore.Images.Media.MIME_TYPE + "=?"

    }

    override fun getSelectionArgs(): Array<String> {
        return if (ConfigManager.isFilterGif()) {
            //过滤GIF
            arrayOf("image/jpeg", "image/png", "image/heic")
        } else arrayOf("image/jpeg", "image/png", "image/heic", "image/gif")
    }

    override fun getOrder(): String = MediaStore.Images.Media.DATE_ADDED + " desc"

    override fun parse(cursor: Cursor): MediaFile {
        val path = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.DATA))
        val mime = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.MIME_TYPE))
        val folderId = cursor.getInt(cursor.getColumnIndex(MediaStore.Images.Media.BUCKET_ID))
        val folderName = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.BUCKET_DISPLAY_NAME))
        val dateToken = cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.DATE_TAKEN))
        val dateAdded = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.DATE_ADDED))
        return MediaFile(path = path, mime = mime, folderId = folderId, folderName = folderName, duration = 0, dateToken = dateToken, dateAdded = dateAdded)
    }

}