/*
 * Decompiled with CFR 0.152.
 */
package com.guagua.guagua.image.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.guagua.guagua.image.R;
import com.guagua.guagua.image.data.ItemType;
import com.guagua.guagua.image.data.MediaFile;
import com.guagua.guagua.image.manager.ConfigManager;
import com.guagua.guagua.image.manager.SelectionManager;
import com.guagua.guagua.image.utils.FastClickChecker;
import com.guagua.guagua.image.utils.Utils;
import com.guagua.guagua.image.view.RoundImageView;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005#$%&'B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u0017J\u001a\u0010\u001b\u001a\u00020\u00122\b\b\u0001\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0017H\u0016J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/guagua/guagua/image/adapter/ImagePickerAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$BaseHolder;", "mContext", "Landroid/content/Context;", "mMediaFileList", "", "Lcom/guagua/guagua/image/data/MediaFile;", "(Landroid/content/Context;Ljava/util/List;)V", "fastClickChecker", "Lcom/guagua/guagua/image/utils/FastClickChecker;", "getFastClickChecker", "()Lcom/guagua/guagua/image/utils/FastClickChecker;", "isShowCamera", "", "mOnItemClickListener", "Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$OnItemClickListener;", "bindMedia", "", "mediaHolder", "Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$MediaHolder;", "mediaFile", "getItemCount", "", "getItemViewType", "position", "getMediaFile", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setOnItemClickListener", "onItemClickListener", "BaseHolder", "ImageHolder", "MediaHolder", "OnItemClickListener", "VideoHolder", "imagepicker_release"})
public final class ImagePickerAdapter
extends RecyclerView.Adapter<BaseHolder> {
    private final boolean isShowCamera;
    @NotNull
    private final FastClickChecker fastClickChecker;
    private OnItemClickListener mOnItemClickListener;
    private final Context mContext;
    private final List<MediaFile> mMediaFileList;

    @NotNull
    public final FastClickChecker getFastClickChecker() {
        return this.fastClickChecker;
    }

    public int getItemCount() {
        if (this.mMediaFileList == null) {
            return 0;
        }
        return this.isShowCamera ? this.mMediaFileList.size() + 1 : this.mMediaFileList.size();
    }

    public int getItemViewType(int position) {
        int position2 = position;
        if (this.isShowCamera) {
            if (position2 == 0) {
                return ItemType.INSTANCE.getITEM_TYPE_CAMERA();
            }
            --position2;
        }
        List<MediaFile> list = this.mMediaFileList;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list.get(position2).getDuration() > 0L ? ItemType.INSTANCE.getITEM_TYPE_VIDEO() : ItemType.INSTANCE.getITEM_TYPE_IMAGE();
    }

    @Nullable
    public final MediaFile getMediaFile(int position) {
        MediaFile mediaFile;
        if (this.isShowCamera) {
            if (position == 0) {
                mediaFile = null;
            } else {
                List<MediaFile> list = this.mMediaFileList;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                mediaFile = list.get(position - 1);
            }
        } else {
            List<MediaFile> list = this.mMediaFileList;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            mediaFile = list.get(position);
        }
        return mediaFile;
    }

    @NotNull
    public BaseHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        View view = null;
        if (viewType == ItemType.INSTANCE.getITEM_TYPE_CAMERA()) {
            View view2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_recyclerview_camera, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"LayoutInflater.from(mCon\u2026ecyclerview_camera, null)");
            view = view2;
            return new BaseHolder(view);
        }
        if (viewType == ItemType.INSTANCE.getITEM_TYPE_IMAGE()) {
            View view3 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_recyclerview_image, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"LayoutInflater.from(mCon\u2026recyclerview_image, null)");
            view = view3;
            return new ImageHolder(view);
        }
        View view4 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_recyclerview_video, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"LayoutInflater.from(mCon\u2026recyclerview_video, null)");
        view = view4;
        return new VideoHolder(view);
    }

    public void onBindViewHolder(@NonNull @NotNull BaseHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        int itemType = this.getItemViewType(position);
        MediaFile mediaFile = this.getMediaFile(position);
        int n = itemType;
        if (n == ItemType.INSTANCE.getITEM_TYPE_IMAGE() || n == ItemType.INSTANCE.getITEM_TYPE_VIDEO()) {
            MediaHolder mediaHolder = (MediaHolder)holder;
            MediaFile mediaFile2 = mediaFile;
            if (mediaFile2 == null) {
                Intrinsics.throwNpe();
            }
            this.bindMedia(mediaHolder, mediaFile2);
        }
        if (this.mOnItemClickListener != null) {
            holder.getMSquareRelativeLayout().setOnClickListener(new View.OnClickListener(this, holder, position){
                final /* synthetic */ ImagePickerAdapter this$0;
                final /* synthetic */ BaseHolder $holder;
                final /* synthetic */ int $position;

                public final void onClick(View view) {
                    if (this.this$0.getFastClickChecker().isFastClick((View)this.$holder.getMSquareRelativeLayout())) {
                        return;
                    }
                    OnItemClickListener onItemClickListener = ImagePickerAdapter.access$getMOnItemClickListener$p(this.this$0);
                    if (onItemClickListener == null) {
                        Intrinsics.throwNpe();
                    }
                    View view2 = view;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
                    onItemClickListener.onMediaClick(view2, this.$position);
                }
                {
                    this.this$0 = imagePickerAdapter;
                    this.$holder = baseHolder;
                    this.$position = n;
                }
            });
            if (holder instanceof MediaHolder) {
                ((MediaHolder)holder).getMImageCheck().setOnClickListener(new View.OnClickListener(this, position){
                    final /* synthetic */ ImagePickerAdapter this$0;
                    final /* synthetic */ int $position;

                    public final void onClick(View view) {
                        OnItemClickListener onItemClickListener = ImagePickerAdapter.access$getMOnItemClickListener$p(this.this$0);
                        if (onItemClickListener == null) {
                            Intrinsics.throwNpe();
                        }
                        View view2 = view;
                        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
                        onItemClickListener.onMediaCheck(view2, this.$position);
                    }
                    {
                        this.this$0 = imagePickerAdapter;
                        this.$position = n;
                    }
                });
                ((MediaHolder)holder).getMImageChecked().setOnClickListener(new View.OnClickListener(this, position){
                    final /* synthetic */ ImagePickerAdapter this$0;
                    final /* synthetic */ int $position;

                    public final void onClick(View view) {
                        OnItemClickListener onItemClickListener = ImagePickerAdapter.access$getMOnItemClickListener$p(this.this$0);
                        if (onItemClickListener == null) {
                            Intrinsics.throwNpe();
                        }
                        View view2 = view;
                        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
                        onItemClickListener.onMediaCheck(view2, this.$position);
                    }
                    {
                        this.this$0 = imagePickerAdapter;
                        this.$position = n;
                    }
                });
            }
        }
    }

    private final void bindMedia(MediaHolder mediaHolder, MediaFile mediaFile) {
        String imagePath = mediaFile.getPath();
        if (!TextUtils.isEmpty((CharSequence)imagePath)) {
            int n;
            Log.e((String)"ImagePickerAdapter", (String)("isImageSelect:" + SelectionManager.INSTANCE.isImageSelect(imagePath)));
            if (SelectionManager.INSTANCE.isImageSelect(imagePath)) {
                mediaHolder.getMImageCheck().setVisibility(8);
                mediaHolder.getMImageChecked().setVisibility(0);
                mediaHolder.getMImageChecked().setText((CharSequence)String.valueOf(SelectionManager.INSTANCE.indexOf(imagePath)));
            } else {
                mediaHolder.getMImageView().setColorFilter(null);
                mediaHolder.getMImageView().setVisibility(0);
                mediaHolder.getMImageCheck().setVisibility(0);
                mediaHolder.getMImageCheck().setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_image_check));
                mediaHolder.getMImageChecked().setVisibility(8);
                mediaHolder.getMImageChecked().setText((CharSequence)"");
            }
            try {
                String string2 = imagePath;
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl = false;
                    n = 0;
                    String it = string3;
                    boolean bl2 = false;
                    ConfigManager.INSTANCE.getImageLoader().loadImage(mediaHolder.getMImageView(), it);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (mediaHolder instanceof ImageHolder) {
                String suffix;
                String string4 = imagePath;
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                String string5 = string4;
                n = StringsKt.lastIndexOf$default((CharSequence)imagePath, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
                boolean bl = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string5 = suffix = string7;
                n = 0;
                String string8 = string5;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).toUpperCase()");
                if (Intrinsics.areEqual((Object)string9, (Object)"GIF")) {
                    ((ImageHolder)mediaHolder).getMImageGif().setVisibility(0);
                } else {
                    ((ImageHolder)mediaHolder).getMImageGif().setVisibility(8);
                }
            }
            if (mediaHolder instanceof VideoHolder) {
                String duration = Utils.INSTANCE.getVideoDuration(mediaFile.getDuration());
                ((VideoHolder)mediaHolder).getMVideoDuration().setText((CharSequence)duration);
            }
        }
    }

    public final void setOnItemClickListener(@NotNull OnItemClickListener onItemClickListener) {
        Intrinsics.checkParameterIsNotNull((Object)onItemClickListener, (String)"onItemClickListener");
        this.mOnItemClickListener = onItemClickListener;
    }

    public ImagePickerAdapter(@NotNull Context mContext, @Nullable List<MediaFile> mMediaFileList) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.mMediaFileList = mMediaFileList;
        this.fastClickChecker = new FastClickChecker();
        this.isShowCamera = ConfigManager.INSTANCE.isShowCamera();
    }

    public static final /* synthetic */ OnItemClickListener access$getMOnItemClickListener$p(ImagePickerAdapter $this) {
        return $this.mOnItemClickListener;
    }

    public static final /* synthetic */ void access$setMOnItemClickListener$p(ImagePickerAdapter $this, OnItemClickListener onItemClickListener) {
        $this.mOnItemClickListener = onItemClickListener;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$ImageHolder;", "Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$MediaHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "mImageGif", "Landroid/widget/ImageView;", "getMImageGif", "()Landroid/widget/ImageView;", "setMImageGif", "(Landroid/widget/ImageView;)V", "imagepicker_release"})
    public static final class ImageHolder
    extends MediaHolder {
        @NotNull
        private ImageView mImageGif;

        @NotNull
        public final ImageView getMImageGif() {
            return this.mImageGif;
        }

        public final void setMImageGif(@NotNull ImageView imageView) {
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"<set-?>");
            this.mImageGif = imageView;
        }

        public ImageHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.iv_item_gif);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.iv_item_gif)");
            this.mImageGif = (ImageView)view;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$VideoHolder;", "Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$MediaHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "mVideoDuration", "Landroid/widget/TextView;", "getMVideoDuration", "()Landroid/widget/TextView;", "setMVideoDuration", "(Landroid/widget/TextView;)V", "imagepicker_release"})
    public static final class VideoHolder
    extends MediaHolder {
        @NotNull
        private TextView mVideoDuration;

        @NotNull
        public final TextView getMVideoDuration() {
            return this.mVideoDuration;
        }

        public final void setMVideoDuration(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.mVideoDuration = textView;
        }

        public VideoHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.tv_item_videoDuration);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.tv_item_videoDuration)");
            this.mVideoDuration = (TextView)view;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$MediaHolder;", "Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$BaseHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "mImageCheck", "Landroid/widget/ImageView;", "getMImageCheck", "()Landroid/widget/ImageView;", "setMImageCheck", "(Landroid/widget/ImageView;)V", "mImageChecked", "Landroid/widget/TextView;", "getMImageChecked", "()Landroid/widget/TextView;", "setMImageChecked", "(Landroid/widget/TextView;)V", "mImageView", "Lcom/guagua/guagua/image/view/RoundImageView;", "getMImageView", "()Lcom/guagua/guagua/image/view/RoundImageView;", "setMImageView", "(Lcom/guagua/guagua/image/view/RoundImageView;)V", "imagepicker_release"})
    public static class MediaHolder
    extends BaseHolder {
        @NotNull
        private RoundImageView mImageView;
        @NotNull
        private ImageView mImageCheck;
        @NotNull
        private TextView mImageChecked;

        @NotNull
        public final RoundImageView getMImageView() {
            return this.mImageView;
        }

        public final void setMImageView(@NotNull RoundImageView roundImageView) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)roundImageView), (String)"<set-?>");
            this.mImageView = roundImageView;
        }

        @NotNull
        public final ImageView getMImageCheck() {
            return this.mImageCheck;
        }

        public final void setMImageCheck(@NotNull ImageView imageView) {
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"<set-?>");
            this.mImageCheck = imageView;
        }

        @NotNull
        public final TextView getMImageChecked() {
            return this.mImageChecked;
        }

        public final void setMImageChecked(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.mImageChecked = textView;
        }

        public MediaHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.iv_item_image);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.iv_item_image)");
            this.mImageView = (RoundImageView)view;
            View view2 = itemView.findViewById(R.id.iv_item_check);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView.findViewById(R.id.iv_item_check)");
            this.mImageCheck = (ImageView)view2;
            View view3 = itemView.findViewById(R.id.tv_item_check);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView.findViewById(R.id.tv_item_check)");
            this.mImageChecked = (TextView)view3;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$BaseHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "mSquareRelativeLayout", "Landroid/widget/RelativeLayout;", "getMSquareRelativeLayout", "()Landroid/widget/RelativeLayout;", "setMSquareRelativeLayout", "(Landroid/widget/RelativeLayout;)V", "imagepicker_release"})
    public static class BaseHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private RelativeLayout mSquareRelativeLayout;

        @NotNull
        public final RelativeLayout getMSquareRelativeLayout() {
            return this.mSquareRelativeLayout;
        }

        public final void setMSquareRelativeLayout(@NotNull RelativeLayout relativeLayout) {
            Intrinsics.checkParameterIsNotNull((Object)relativeLayout, (String)"<set-?>");
            this.mSquareRelativeLayout = relativeLayout;
        }

        public BaseHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.srl_item);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.srl_item)");
            this.mSquareRelativeLayout = (RelativeLayout)view;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lcom/guagua/guagua/image/adapter/ImagePickerAdapter$OnItemClickListener;", "", "onMediaCheck", "", "view", "Landroid/view/View;", "position", "", "onMediaClick", "imagepicker_release"})
    public static interface OnItemClickListener {
        public void onMediaClick(@NotNull View var1, int var2);

        public void onMediaCheck(@NotNull View var1, int var2);
    }
}

