package com.guagua.guagua.image.view

import android.content.Context
import android.graphics.Canvas
import android.graphics.Path
import android.graphics.RectF
import android.util.AttributeSet
import android.widget.RelativeLayout

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 18:24
 * Version: 1.0.0
 * Description: 矩形布局
 * History:
 * <author> <time> <version> <desc>
 */
class SquareRelativeLayout @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr) {

    override fun onDraw(canvas: Canvas) {
        val path = Path()
        path.addRoundRect(
            RectF(0f, 0f, width.toFloat(), height.toFloat()),
            16f,
            16f,
            Path.Direction.CW
        )
        canvas.clipPath(path)//设置可显示的区域，canvas四个角会被剪裁掉
        super.onDraw(canvas)
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, widthMeasureSpec)
    }
}