package com.guagua.guagua.image.view

import android.content.Context
import android.graphics.*
import android.graphics.drawable.shapes.RoundRectShape
import android.graphics.drawable.shapes.Shape
import android.os.Build
import android.util.AttributeSet
import android.view.View
import android.view.View.LAYER_TYPE_HARDWARE
import androidx.annotation.Nullable
import androidx.appcompat.widget.AppCompatImageView
import androidx.core.view.ViewCompat.setLayerType
import com.guagua.guagua.image.R
import java.security.AccessController.getContext
import java.util.*

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 17:53
 * Version: 1.0.0
 * Description: 矩形图片
 * History:
 * <author> <time> <version> <desc>
 */
class SquareImageView(context: Context, attrs: AttributeSet?): AppCompatImageView(context, attrs) {

    private val paint = Paint(Paint.ANTI_ALIAS_FLAG)
    private val SHAPE_MODE_ROUND_RECT = 1
    private val SHAPE_MODE_CIRCLE = 2

    private var mShapeMode = 0
    private var mRadius = 0f
    private var mShape: Shape? = null
    private var mPaint: Paint? = null

    init {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            setLayerType(View.LAYER_TYPE_HARDWARE, null)
        }
        if (null != attrs) {
            val a = context.obtainStyledAttributes(attrs, R.styleable.ShapedImageView)
            mShapeMode = a.getInt(R.styleable.ShapedImageView_shape_mode, 0)
            mRadius = a.getDimension(R.styleable.ShapedImageView_round_radius, 0f)
            a.recycle()
        }
        paint.isFilterBitmap = true
        paint.color = Color.BLACK
        paint.xfermode = PorterDuffXfermode(PorterDuff.Mode.DST_IN)
    }

    override fun onLayout(changed: Boolean, left: Int, top: Int, right: Int, bottom: Int) {
        super.onLayout(changed, left, top, right, bottom)
        if (changed) {
            when (mShapeMode) {
                SHAPE_MODE_ROUND_RECT -> {
                }
                SHAPE_MODE_CIRCLE -> {
                    val min = Math.min(width, height)
                    mRadius = min.toFloat() / 2
                }
            }
            if (mShape == null) {
                val radius = FloatArray(8)
                Arrays.fill(radius, mRadius)
                mShape = RoundRectShape(radius, null, null)
            }
            mShape!!.resize(width.toFloat(), height.toFloat())
        }
    }

    override fun onDraw(canvas: Canvas) {
        val saveCount = canvas.saveCount
        canvas.save()
        super.onDraw(canvas)
        when (mShapeMode) {
            SHAPE_MODE_ROUND_RECT, SHAPE_MODE_CIRCLE -> if (mShape != null) {
                mShape!!.draw(canvas, mPaint)
            }
        }
        canvas.restoreToCount(saveCount)
    }
}