package com.guagua.guagua.image.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import androidx.annotation.NonNull
import androidx.viewpager.widget.PagerAdapter
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.listener.OnImageClick
import com.guagua.guagua.image.manager.ConfigManager
import java.util.*

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/28 17:59
 * Version: 1.0.0
 * Description: 大图浏览适配器（并不是比较好的方案，后期会用RecyclerView来实现）
 * History:
 * <author> <time> <version> <desc>
 */
class ImagePreViewAdapter(
    private val mContext: Context,
    private val mMediaFileList: List<MediaFile>?
) : PagerAdapter() {

    var onImageClick: OnImageClick? = null

    internal var viewCache = LinkedList<PinchImageView>()

    override fun isViewFromObject(@NonNull view: View, @NonNull `object`: Any): Boolean {
        return view === `object`
    }

    override fun getCount(): Int = mMediaFileList?.size ?: 0

    override fun instantiateItem(@NonNull container: ViewGroup, position: Int): Any {
        val imageView: PinchImageView
        if (viewCache.size > 0) {
            imageView = viewCache.remove()
            imageView.reset()
        } else {
            imageView = PinchImageView(mContext)
        }
        try {
            ConfigManager.getImageLoader().loadPreImage(imageView, mMediaFileList!![position].path)
        } catch (e: Exception) {
            e.printStackTrace()
        }

        imageView.setOnClickListener{
            onImageClick?.let { it.onClick() }
        }
        container.addView(imageView)
        return imageView
    }

    override fun destroyItem(@NonNull container: ViewGroup, position: Int, @NonNull `object`: Any) {
        val imageView = `object` as PinchImageView
        container.removeView(imageView)
        viewCache.add(imageView)
    }

    fun setOnImageClickListener(listener: OnImageClick) {
        onImageClick = listener
    }
}