package com.guagua.guagua.image.view

import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.view.LayoutInflater
import android.view.MotionEvent
import android.view.View
import android.widget.PopupWindow
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.guagua.guagua.image.R
import com.guagua.guagua.image.adapter.ImageFoldersAdapter
import com.guagua.guagua.image.data.MediaFolder
import com.guagua.guagua.image.utils.Utils

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/28 14:47
 * Version: 1.0.0
 * Description: 图片文件夹列表窗口
 * History:
 * <author> <time> <version> <desc>
 */
class ImageFolderPopupWindow(context: Context, mediaFolderList: List<MediaFolder>): PopupWindow() {
    private val DEFAULT_IMAGE_FOLDER_SELECT = 0//默认选中文件夹

    private val mContext: Context
    private val mMediaFolderList: List<MediaFolder>

    private var mRecyclerView: RecyclerView? = null
    private var mImageFoldersAdapter: ImageFoldersAdapter? = null

    init {
        this.mContext = context
        this.mMediaFolderList = mediaFolderList
        initView()
    }

    /**
     * 初始化布局
     */
    private fun initView() {
        val view = LayoutInflater.from(mContext).inflate(R.layout.window_image_folders, null)
        mRecyclerView = view.findViewById(R.id.rv_main_imageFolders)
        mRecyclerView?.layoutManager = LinearLayoutManager(mContext)
        mImageFoldersAdapter = ImageFoldersAdapter(mContext, mMediaFolderList, DEFAULT_IMAGE_FOLDER_SELECT)
        mRecyclerView?.adapter = mImageFoldersAdapter

        initPopupWindow(view)
    }

    /**
     * 初始化PopupWindow的一些属性
     */
    private fun initPopupWindow(view: View) {
        contentView = view
        val screenSize = Utils.getScreenSize(mContext)
        width = screenSize[0]
        height = (screenSize[1] * 1).toInt() - dp2px(mContext, 44) - getStatusHeight(mContext)
        setBackgroundDrawable(ColorDrawable(0x00000000))
        isOutsideTouchable = true
        isFocusable = true
        setTouchInterceptor { view, motionEvent ->
            if (motionEvent.action == MotionEvent.ACTION_OUTSIDE) {
                dismiss()
            }
            false
        }
    }

    fun getAdapter(): ImageFoldersAdapter? = mImageFoldersAdapter


    /**
     * 获得状态栏的高度
     */
    private fun getStatusHeight(mContext: Context): Int {
        var statusHeight = -1
        try {
            val clazz = Class.forName("com.android.internal.R\$dimen")
            val `object` = clazz.newInstance()
            val height = Integer.parseInt(
                clazz.getField("status_bar_height")
                    .get(`object`).toString()
            )
            statusHeight = mContext.resources.getDimensionPixelSize(height)
        } catch (e: Exception) {
            e.printStackTrace()
        }

        return statusHeight
    }

    private fun dp2px(context: Context, dp: Int): Int {
        return (dp * context.resources.displayMetrics.density).toInt()
    }
}