package com.guagua.guagua.image.utils

import android.widget.ImageView
import java.io.Serializable

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 16:06
 * Version: 1.0.0
 * Description: 图片加载接口相关
 * History:
 * <author> <time> <version> <desc>
 */
interface ImageLoader: Serializable {

    /**
     * 缩略图加载方案
     *
     * @param imageView
     * @param imagePath
     */
    abstract fun loadImage(imageView: ImageView, imagePath: String)

    /**
     * 大图加载方案
     *
     * @param imageView
     * @param imagePath
     */
    abstract fun loadPreImage(imageView: ImageView, imagePath: String)


    /**
     * 视频播放方案
     *
     * @param imageView
     * @param path
     */
//    void loadVideoPlay(ImageView imageView, String path);

    /**
     * 缓存管理
     */
    abstract fun clearMemoryCache()
}