package com.guagua.guagua.image.task

import android.content.Context
import android.util.Log
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.listener.MediaLoadCallback
import com.guagua.guagua.image.loader.MediaHandler
import com.guagua.guagua.image.loader.VideoScanner
import java.util.ArrayList

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 20:02
 * Version: 1.0.0
 * Description: 视频扫描器
 * History:
 * <author> <time> <version> <desc>
 */
class VideoLoadTask(context: Context, mediaLoadCallback: MediaLoadCallback): Runnable {

    private val mContext: Context
    private val mVideoScanner: VideoScanner?
    private val mMediaLoadCallback: MediaLoadCallback?

    init {
        mContext = context
        mVideoScanner = VideoScanner(mContext)
        mMediaLoadCallback = mediaLoadCallback
    }
    override fun run() {
        //存放所有照片
        var imageFileList = ArrayList<MediaFile>()
        mVideoScanner?.let { imageFileList = it.queryMedia() }
        Log.e("ImageLoadTask", "run()==================" + imageFileList.size)
        mMediaLoadCallback?.loadMediaSuccess(MediaHandler.getImageFolder(mContext, imageFileList))
    }
}