package com.guagua.guagua.image.manager

import com.guagua.guagua.image.utils.ImageLoader
import java.util.ArrayList

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 15:55
 * Version: 1.0.0
 * Description: 配置管理类
 * History:
 * <author> <time> <version> <desc>
 */
object ConfigManager {

    private val TAG = "ConfigManager"

    val SELECT_MODE_SINGLE = 0
    val SELECT_MODE_MULTI = 1

    private var showCamera: Boolean = false//是否显示拍照Item，默认不显示
    private var showImage = true//是否显示图片，默认显示
    private var showVideo = true//是否显示视频，默认显示
    private var filterGif = false//是否过滤GIF图片，默认不过滤
    private var selectionMode = SELECT_MODE_SINGLE//选择模式，默认单选
    private var maxCount = 1//最大选择数量，默认为1
    private var singleType: Boolean = false//是否只支持选单类型（图片或者视频）
    private var imagePaths: ArrayList<String>? = null//上一次选择的图片地址集合

    private var imageLoader: ImageLoader? = null

    fun isShowCamera(): Boolean = showCamera

    fun setShowCamera(showCamera: Boolean) {
        this.showCamera = showCamera
    }

    fun isShowImage(): Boolean {
        return showImage
    }

    fun setShowImage(showImage: Boolean) {
        this.showImage = showImage
    }

    fun isShowVideo(): Boolean {
        return showVideo
    }

    fun setShowVideo(showVideo: Boolean) {
        this.showVideo = showVideo
    }

    fun getMaxCount(): Int = maxCount

    fun setMaxCount(maxCount: Int) {
        if (maxCount > 1) {
            setSelectionMode(SELECT_MODE_MULTI)
        }
        this.maxCount = maxCount
    }

    fun isFilterGif(): Boolean {
        return filterGif
    }

    fun setFilterGif(filterGif: Boolean) {
        this.filterGif = filterGif
    }

    fun getSelectionMode(): Int {
        return selectionMode
    }

    fun setSelectionMode(mSelectionMode: Int) {
        this.selectionMode = mSelectionMode
    }

    fun getImagePaths(): ArrayList<String>? {
        return imagePaths
    }

    fun setImagePaths(imagePaths: ArrayList<String>) {
        this.imagePaths = imagePaths
    }

    fun isSingleType(): Boolean {
        return singleType
    }

    fun setSingleType(singleType: Boolean) {
        this.singleType = singleType
    }

    @Throws(Exception::class)
    fun getImageLoader(): ImageLoader {
        if (imageLoader == null) {
            throw Exception("imageLoader is null")
        }
        return imageLoader!!
    }

    fun setImageLoader(imageLoader: ImageLoader) {
        this.imageLoader = imageLoader
    }
}