package com.guagua.guagua.image.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.guagua.guagua.image.R
import com.guagua.guagua.image.manager.ConfigManager
import com.guagua.guagua.image.manager.SelectionManager
import com.guagua.guagua.image.view.RoundImageView
import java.util.HashMap

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/28 17:18
 * Version: 1.0.0
 * Description: 选取过的图片列表
 * History:
 * <author> <time> <version> <desc>
 */
class ImageSelectedAdapter(private val context: Context) :
    RecyclerView.Adapter<ImageSelectedAdapter.BaseHolder>() {

    private val mSelectedPath: MutableMap<String, Boolean>

    private var onItemClick: OnItemClick? = null

    init {
        mSelectedPath = HashMap()
        for (i in 0 until SelectionManager.getSelectPaths().size) {
            mSelectedPath[SelectionManager.getSelectPaths()[i]] = false
        }
    }

    override fun getItemCount(): Int = SelectionManager.getSelectPaths().size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.item_recycler_select_img, null)
        return BaseHolder(view)
    }

    override fun onBindViewHolder(holder: BaseHolder, position: Int) {
        try {
            ConfigManager.getImageLoader().loadImage(
                holder.mIvSelected,
                SelectionManager.getSelectPaths()[position]
            )
            if (mSelectedPath[SelectionManager.getSelectPaths().get(position)] == null || mSelectedPath[SelectionManager.getSelectPaths()[position]] == false) {
                holder.mIvSelectedBorder.visibility = View.GONE
            } else {
                holder.mIvSelectedBorder.visibility = View.VISIBLE
            }
            holder.mIvSelected.setOnClickListener {
                if (null != onItemClick) {
                    onItemClick!!.onClick(
                        SelectionManager.getSelectPaths()[position]
                    )
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    /**
     * 基础Item
     */
    class BaseHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        var mIvSelected: RoundImageView
        var mIvSelectedBorder: RoundImageView

        init {
            mIvSelected = itemView.findViewById(R.id.iv_selected_img)
            mIvSelectedBorder = itemView.findViewById(R.id.iv_selected_img_border)
        }
    }

    fun setOnItemClick(onItemClick: OnItemClick) {
        this.onItemClick = onItemClick
    }

    interface OnItemClick {
        fun onClick(path: String)
    }

    fun updateView(path: String, isSelected: Boolean) {
        for ((key, value) in mSelectedPath) {
            println("Key = $key, Value = $value")
            mSelectedPath[key] = false
        }
        mSelectedPath[path] = isSelected
        notifyDataSetChanged()
    }
}