package com.guagua.guagua.image.adapter

import android.content.Context
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.guagua.guagua.image.R
import com.guagua.guagua.image.data.MediaFolder
import com.guagua.guagua.image.manager.ConfigManager

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/28 14:54
 * Version: 1.0.0
 * Description: 图片文件夹适配器
 * History:
 * <author> <time> <version> <desc>
 */

class ImageFoldersAdapter(
    private val mContext: Context,
    private val mMediaFolderList: List<MediaFolder>?,
    private var mCurrentImageFolderIndex: Int
) : RecyclerView.Adapter<ImageFoldersAdapter.ViewHolder>() {

    override fun getItemCount(): Int = mMediaFolderList?.size ?: 0

    /**
     * 接口回调，Item点击事件
     */
    private var mImageFolderChangeListener: ImageFoldersAdapter.OnImageFolderChangeListener? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(mContext).inflate(
                R.layout.item_recyclerview_folder,
                null
            )
        )
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {

        val mediaFolder = mMediaFolderList!![position]
        val folderCover = mediaFolder.folderCover
        val folderName = mediaFolder.folderName
        val imageSize = mediaFolder.mediaFileList?.size

        if (!TextUtils.isEmpty(folderName)) {
            holder.mFolderName.setText(folderName)
        }

        holder.mImageSize.text = String.format(mContext.getString(R.string.image_num), imageSize)

        if (mCurrentImageFolderIndex == position) {
            holder.mImageFolderCheck.visibility = View.VISIBLE
        } else {
            holder.mImageFolderCheck.visibility = View.GONE
        }
        //加载图片
        try {
            folderCover?.let { ConfigManager.getImageLoader().loadImage(holder.mImageCover, it) }
        } catch (e: Exception) {
            e.printStackTrace()
        }

        if (mImageFolderChangeListener != null) {
            holder.itemView.setOnClickListener { view ->
                mCurrentImageFolderIndex = position
                notifyDataSetChanged()
                mImageFolderChangeListener!!.onImageFolderChange(view, position)
            }
        }

    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val mImageCover: ImageView
        val mFolderName: TextView
        val mImageSize: TextView
        val mImageFolderCheck: ImageView

        init {
            mImageCover = itemView.findViewById(R.id.iv_item_imageCover)
            mFolderName = itemView.findViewById(R.id.tv_item_folderName)
            mImageSize = itemView.findViewById(R.id.tv_item_imageSize)
            mImageFolderCheck = itemView.findViewById(R.id.iv_item_check)
        }
    }

    fun setOnImageFolderChangeListener(onItemClickListener: ImageFoldersAdapter.OnImageFolderChangeListener) {
        this.mImageFolderChangeListener = onItemClickListener
    }

    interface OnImageFolderChangeListener {
        fun onImageFolderChange(view: View, position: Int)
    }
}