package com.guagua.guagua.image.activity

import android.Manifest
import android.app.ProgressDialog
import android.content.Intent
import android.graphics.drawable.Drawable
import android.view.View
import com.guagua.guagua.image.ImagePicker
import com.guagua.guagua.image.manager.SelectionManager
import kotlinx.android.synthetic.main.activity_imagepicker.*
import kotlinx.android.synthetic.main.include_layout_actionbar.*
import androidx.core.app.ActivityCompat
import androidx.recyclerview.widget.GridLayoutManager
import com.guagua.guagua.image.R
import com.guagua.guagua.image.adapter.ImagePickerAdapter
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.data.MediaFolder
import com.guagua.guagua.image.manager.ConfigManager
import com.guagua.guagua.image.utils.PermissionUtil
import android.widget.Toast
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Build
import android.os.Environment
import android.provider.MediaStore
import android.text.TextUtils
import androidx.core.content.FileProvider
import com.guagua.guagua.image.adapter.ImageFoldersAdapter
import com.guagua.guagua.image.executors.CommonExecutor
import com.guagua.guagua.image.listener.MediaLoadCallback
import com.guagua.guagua.image.provider.ImagePickerProvider
import com.guagua.guagua.image.task.ImageLoadTask
import com.guagua.guagua.image.task.MediaLoadTask
import com.guagua.guagua.image.task.VideoLoadTask
import com.guagua.guagua.image.utils.DataUtil
import com.guagua.guagua.image.utils.FileSizeUtil
import com.guagua.guagua.image.utils.MediaFileUtil
import com.guagua.guagua.image.view.ImageFolderPopupWindow
import java.io.File


/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 15:24
 * Version: 1.0.0
 * Description: 列表图片选择页面
 * History:
 * <author> <time> <version> <desc>
 */
class ImagePickerActivity: BaseActivity(), ImagePickerAdapter.OnItemClickListener, ImageFoldersAdapter.OnImageFolderChangeListener {
    /**
     * 启动参数
     */
    private var isShowCamera: Boolean = false
    private var isShowImage: Boolean = false
    private var isShowVideo: Boolean = false
    private var isSingleType: Boolean = false
    private var mMaxCount: Int = 0
    private var mImagePaths: List<String>? = null

    private var mGridLayoutManager: GridLayoutManager? = null
    private var mImagePickerAdapter: ImagePickerAdapter? = null
    private var mProgressDialog: ProgressDialog? = null
    private var mImageFolderPopupWindow: ImageFolderPopupWindow? = null

    private var mThemeNormal: Drawable? = null
    private var mThemeSelected: Drawable? = null

    //图片数据源
    private var mMediaFileList: MutableList<MediaFile>? = null
    //文件夹数据源
    private var mMediaFolderList: List<MediaFolder>? = null

    /**
     * 大图预览页相关
     */
    private val REQUEST_SELECT_IMAGES_CODE = 0x01//用于在大图预览页中点击提交按钮标识


    /**
     * 拍照相关
     */
    private var mFilePath: String? = null
    private val REQUEST_CODE_CAPTURE = 0x02//点击拍照标识

    /**
     * 权限相关
     */
    private val REQUEST_PERMISSION_CAMERA_CODE = 0x03

    override fun bindLayout(): Int = R.layout.activity_imagepicker

    override fun initConfig() {
        isShowCamera = ConfigManager.isShowCamera()
        isShowImage = ConfigManager.isShowImage()
        isShowVideo = ConfigManager.isShowVideo()
        isSingleType = ConfigManager.isSingleType()
        mMaxCount = ConfigManager.getMaxCount()
        SelectionManager.setMaxCount(mMaxCount)

        //载入历史选择记录
        mImagePaths = ConfigManager.getImagePaths()
        mImagePaths?.let {
            SelectionManager.addImagePathsToSelectList(it)
        }
    }

    override fun initView() {
        mProgressDialog = ProgressDialog.show(this, null, getString(R.string.scanner_image))
        mThemeNormal = resources.getDrawable(R.drawable.icon_album_index)
        mThemeSelected = resources.getDrawable(R.drawable.icon_album_index_selected)

        mGridLayoutManager = GridLayoutManager(this, 4)
        rvMainImages.layoutManager = mGridLayoutManager
        rvMainImages.setHasFixedSize(true)
        rvMainImages.setItemViewCacheSize(60)

        mMediaFileList = ArrayList()
        mImagePickerAdapter = ImagePickerAdapter(this, mMediaFileList!!)
        mImagePickerAdapter!!.setOnItemClickListener(this)
        rvMainImages.adapter = mImagePickerAdapter
    }

    override fun initListener() {
        ivActionBarBack.setOnClickListener {
            setResult(RESULT_CANCELED)
            finish()
        }

        tvSendImages.setOnClickListener {
            sendSelected()
        }

        tvMainImageFolders.setOnClickListener {
            mImageFolderPopupWindow?.let {
                tvMainImageFolders.setCompoundDrawablesWithIntrinsicBounds(null, null, mThemeSelected, null)
                it.showAsDropDown(tvMainImageFolders, 0, 0)
            }
        }
    }

    override fun getData() {
        //进行权限的判断
        val hasPermission = PermissionUtil.checkPermission(this)
        var permissions = arrayOf(Manifest.permission.WRITE_EXTERNAL_STORAGE)
        if (ConfigManager.isShowCamera()) {
            permissions = arrayOf(Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE)
        }
        if (!hasPermission) {
            ActivityCompat.requestPermissions(this, permissions, REQUEST_PERMISSION_CAMERA_CODE)
        } else {
            startScannerTask()
        }
    }

    override fun onMediaClick(view: View, position: Int) {
        if (isShowCamera) {
            if (position == 0) {
                if (!SelectionManager.isCanChoose()) {
                    showMessage(String.format(getString(R.string.select_image_max), mMaxCount))
                    return
                }
                showCamera()
                return
            }
        }

        if (mMediaFileList != null) {
            DataUtil.instance?.setMediaData(mMediaFileList!!)
            val intent = Intent(this, ImagePreActivity::class.java)
            if (isShowCamera) {
                intent.putExtra(ImagePreActivity.IMAGE_POSITION, position - 1)
            } else {
                intent.putExtra(ImagePreActivity.IMAGE_POSITION, position)
            }
            startActivityForResult(intent, REQUEST_SELECT_IMAGES_CODE)
        }
    }

    override fun onMediaCheck(view: View, position: Int) {
        if (isShowCamera) {
            if (position == 0) {
                if (!SelectionManager.isCanChoose()) {
                    showMessage(String.format(getString(R.string.select_image_max), mMaxCount))
                    return
                }
                showCamera()
                return
            }
        }

        //执行选中/取消操作
        val mediaFile = mImagePickerAdapter?.getMediaFile(position)
        if (MediaFileUtil.isVideoFileType(mediaFile!!.path)) {
            if (!mediaFile!!.path.toLowerCase().endsWith(".mp4")) {
                showMessage("只能发送MP4格式的视频")
                return
            }
            if (mediaFile.duration.toInt() === 0) {
                showMessage("视频时长无效")
                return
            }
            if (mediaFile.duration > FileSizeUtil.SIZETYPE_LIMIT_DURATION) {
                showMessage("不能分享超过2分钟的视频")
                return
            }
            if (FileSizeUtil.getFileOrFilesSize(mediaFile.path, FileSizeUtil.SIZETYPE_MB) > FileSizeUtil.SIZETYPE_LIMIT_SIZE) {
                showMessage("不能分享超过20M的视频")
                return
            }
        }

        if (mediaFile != null) {
            val imagePath = mediaFile.path
            if (isSingleType) {
                //如果是单类型选取，判断添加类型是否满足（照片视频不能共存）
                val selectPathList = SelectionManager.getSelectPaths()
                if (!selectPathList.isEmpty()) {
                    //判断选中集合中第一项是否为视频
                    if (!SelectionManager.isCanAddSelectionPaths(imagePath, selectPathList[0])) {
                        //类型不同
                        showMessage(getString(R.string.single_type_choose))
                        return
                    }
                }
            }
            val isAdded = SelectionManager.isImageSelect(imagePath)
            val addSuccess = SelectionManager.addImageDurationToSelectList(imagePath, mediaFile.duration)
            if (addSuccess) {
                if (isAdded) {
                    mImagePickerAdapter?.notifyDataSetChanged()
                } else {
                    mImagePickerAdapter?.notifyItemChanged(position)
                }
            } else {
                showMessage(String.format(getString(R.string.select_image_max), mMaxCount))
            }
        }
        updateCommitButton()
    }

    override fun onImageFolderChange(view: View, position: Int) {
        val mediaFolder = mMediaFolderList?.get(position)
        //更新当前文件夹名
        val folderName = mediaFolder?.folderName
        if (!TextUtils.isEmpty(folderName)) {
            tvMainImageFolders.setText(folderName)
        }
        //更新图片列表数据源
        mMediaFileList?.clear()
        mediaFolder?.mediaFileList?.let { mMediaFileList?.addAll(it) }
        mImagePickerAdapter?.notifyDataSetChanged()

        mImageFolderPopupWindow?.dismiss()
    }

    private fun startScannerTask() {
        var mediaLoadTask: Runnable? = null
        if (isShowImage && isShowVideo) {
            //照片、视频全部加载
            mediaLoadTask = MediaLoadTask(this, MediaLoader())
        }
        if (isShowVideo && !isShowImage) {
            //只加载视频
            mediaLoadTask = VideoLoadTask(this, MediaLoader())
        }
        if (isShowImage && !isShowVideo) {
            //只加载图片
            mediaLoadTask = ImageLoadTask(this, MediaLoader())
        }
        if (mediaLoadTask == null) {
            //不符合以上场景，采用照片、视频全部加载
            mediaLoadTask = MediaLoadTask(this, MediaLoader())
        }
        CommonExecutor.instance?.execute(mediaLoadTask!!)
    }

    private fun sendSelected() {
        val list = ArrayList(SelectionManager.getSelectPaths())
        val intent = Intent()
        intent.putStringArrayListExtra(ImagePicker.EXTRA_SELECT_IMAGES, list)
        setResult(RESULT_OK, intent)
        SelectionManager.removeAll()//清空选中记录
        finish()
    }

    /**
     * 更新确认按钮状态
     */
    private fun updateCommitButton() {
        //改变确定按钮UI
        val selectCount = SelectionManager.getSelectPaths().size
        if (selectCount == 0) {
            tvSendImages.isEnabled = false
            tvSendImages.text = getString(R.string.confirm)
            tvSendImages.setBackgroundResource(R.drawable.image_send_normal)
            tvImagesCount.text = "选择 0 张"
            return
        }
        if (selectCount < mMaxCount) {
            tvSendImages.isEnabled = true
            tvSendImages.setBackgroundResource(R.drawable.image_send_selected)
            tvSendImages.text = getString(R.string.confirm)
            tvImagesCount.text = "选择 $selectCount 张"
            return
        }
        if (selectCount == mMaxCount) {
            tvSendImages.isEnabled = true
            tvSendImages.setBackgroundResource(R.drawable.image_send_selected)
            tvSendImages.text = getString(R.string.confirm)
            tvImagesCount.text = "选择 $selectCount 张"
            return
        }
    }

    inner class MediaLoader: MediaLoadCallback {
        override fun loadMediaSuccess(mediaFolderList: MutableList<MediaFolder>) {
            runOnUiThread {
                mediaFolderList?.let {
                    mMediaFolderList = mediaFolderList.toMutableList()
                    mImageFolderPopupWindow = ImageFolderPopupWindow(this@ImagePickerActivity, it)
                    mImageFolderPopupWindow?.animationStyle = R.style.imageFolderAnimator
                    mImageFolderPopupWindow?.getAdapter()!!.setOnImageFolderChangeListener(this@ImagePickerActivity)
                    mImageFolderPopupWindow?.setOnDismissListener {
                        tvMainImageFolders.setCompoundDrawablesWithIntrinsicBounds(null, null, mThemeNormal, null)
                    }
                    updateCommitButton()

                    //默认加载全部照片
                    val mediaFolder = it.get(0)
                    //更新当前文件夹名
                    val folderName = mediaFolder.folderName
                    if (!TextUtils.isEmpty(folderName)) {
                        tvMainImageFolders.text = folderName
                    }
                    //更新图片列表数据源
                    mMediaFileList?.clear()
                    mediaFolder.mediaFileList?.let { mMediaFileList?.addAll(it) }
                    mImagePickerAdapter?.notifyDataSetChanged()

                }
                mProgressDialog?.dismiss()
            }
        }
    }

    /**
     * 跳转相机拍照
     */
    private fun showCamera() {
        if (isSingleType) {
            //如果是单类型选取，判断添加类型是否满足（照片视频不能共存）
            val selectPathList = SelectionManager.getSelectPaths()
            if (!selectPathList.isEmpty()) {
                if (MediaFileUtil.isVideoFileType(selectPathList.get(0))) {
                    //如果存在视频，就不能拍照了
                    showMessage(getString(R.string.single_type_choose))
                    return
                }
            }
        }

        //拍照存放路径
        val fileDir = File(Environment.getExternalStorageDirectory(), "Pictures")
        if (!fileDir.exists()) {
            fileDir.mkdir()
        }
        mFilePath = fileDir.absolutePath + "/IMG_" + System.currentTimeMillis() + ".jpg"

        val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
        val uri: Uri
        if (Build.VERSION.SDK_INT >= 24) {
            uri = FileProvider.getUriForFile(this, ImagePickerProvider.getFileProviderName(this), File(mFilePath))
        } else {
            uri = Uri.fromFile(File(mFilePath))
        }
        intent.putExtra(MediaStore.EXTRA_OUTPUT, uri)
        startActivityForResult(intent, REQUEST_CODE_CAPTURE)
    }

    override fun onResume() {
        super.onResume()
        mImagePickerAdapter?.notifyDataSetChanged()
        updateCommitButton()
    }

    override fun onBackPressed() {
        setResult(RESULT_CANCELED)
        super.onBackPressed()
    }

    override fun onDestroy() {
        super.onDestroy()
        try {
            ConfigManager.getImageLoader().clearMemoryCache()
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    override fun finish() {
        super.finish()
        overridePendingTransition(0, R.anim.activity_show_anim)
    }

    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<out String>, grantResults: IntArray) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        if (requestCode === REQUEST_PERMISSION_CAMERA_CODE) {
            if (grantResults.isNotEmpty()) {
                var cameraGranted: Boolean
                var sdGranted: Boolean

                if (ConfigManager.isShowCamera()) {
                    cameraGranted = grantResults[0] == PackageManager.PERMISSION_GRANTED//拍照权限
                    sdGranted = grantResults[1] == PackageManager.PERMISSION_GRANTED//SD权限
                } else {
                    cameraGranted = true
                    sdGranted = grantResults[0] == PackageManager.PERMISSION_GRANTED//SD权限
                }

                if (cameraGranted && sdGranted) {
                    //具有拍照权限，sd卡权限，开始扫描任务
                    startScannerTask()
                } else {
                    //没有权限
                    showMessage(getString(R.string.permission_tip))
                    finish()
                }
            }
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == RESULT_OK) {
            if (requestCode == REQUEST_CODE_CAPTURE) {
                //通知媒体库刷新
                sendBroadcast(Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, Uri.parse("file://$mFilePath")))
                //添加到选中集合
                mFilePath?.let { SelectionManager.addImageToSelectList(it) }
                sendSelected()
            }

            if (requestCode == REQUEST_SELECT_IMAGES_CODE) {
                sendSelected()
            }
        }
    }
}