package com.guagua.guagua.image.activity

import android.os.Build
import android.os.Bundle
import android.util.Log
import android.view.View
import android.view.WindowManager
import android.widget.Toast
import androidx.annotation.Nullable
import androidx.appcompat.app.AppCompatActivity
import com.guagua.guagua.image.R
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.manager.SelectionManager
import kotlinx.android.synthetic.main.activity_pre.*

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 15:14
 * Version: 1.0.0
 * Description: 基础活动页面
 * History:
 * <author> <time> <version> <desc>
 */
abstract class BaseActivity:AppCompatActivity() {

    private var mView: View? = null

    override fun onCreate(@Nullable savedInstanceState: Bundle?) {
        var savedInstanceState = savedInstanceState
        //解决 app在后台 ， 然后禁止位置权限 在此打开 app奔溃的问题
        savedInstanceState = null
        super.onCreate(savedInstanceState)
        //在5.0系统以上设置状态栏颜色
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val window = window
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS)
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS)
            window.statusBarColor = resources.getColor(R.color.tool_bar_color)
        }

        if (mView == null) {
            mView = View.inflate(this, bindLayout(), null)
        }

        setContentView(mView)

        initConfig()
        initView()
        initListener()
        getData()
    }

    override fun onRestoreInstanceState(savedInstanceState: Bundle?) {
        var savedInstanceState = savedInstanceState
        //解决app 去后台设置中 设置权限相关的开关后。重新打开app 崩溃的问题。
        Log.e("BXCP", "$this  onRestoreInstanceState -----$savedInstanceState")
        try {
            super.onRestoreInstanceState(savedInstanceState)
        } catch (e: Exception) {
            savedInstanceState = null
        }
    }

    protected abstract fun bindLayout(): Int

    protected abstract fun initConfig()

    protected abstract fun initView()

    protected abstract fun initListener()

    protected abstract fun getData()


    protected fun showMessage(msg: String?) {
        if (msg != null && msg != "") {
            val toast = Toast.makeText(applicationContext, msg, Toast.LENGTH_LONG)
            toast.setText(msg)
            toast.show()
        }
    }

    protected fun showMessage(msg: Int) {
        if (msg != null && msg > 0) {
            val toast = Toast.makeText(applicationContext, msg, Toast.LENGTH_LONG)
            toast.setText(msg)
            toast.show()
        }
    }
}