package com.guagua.guagua.image

import android.app.Activity
import android.content.Intent
import com.guagua.guagua.image.activity.ImagePickerActivity
import com.guagua.guagua.image.manager.ConfigManager
import com.guagua.guagua.image.utils.ImageLoader
import java.util.ArrayList

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 14:34
 * Version: 1.0.0
 * Description: 统一调用入口
 * History:
 * <author> <time> <version> <desc>
 */
object ImagePicker {
    val EXTRA_SELECT_IMAGES = "selectItems"

    /**
     * 是否支持相机
     *
     * @param showCamera
     * @return
     */
    fun showCamera(showCamera: Boolean): ImagePicker {
        ConfigManager.setShowCamera(showCamera)
        return this
    }

    /**
     * 是否展示图片
     *
     * @param showImage
     * @return
     */
    fun showImage(showImage: Boolean): ImagePicker {
        ConfigManager.setShowImage(showImage)
        return this
    }

    /**
     * 是否展示视频
     *
     * @param showVideo
     * @return
     */
    fun showVideo(showVideo: Boolean): ImagePicker {
        ConfigManager.setShowVideo(showVideo)
        return this
    }

    /**
     * 是否过滤GIF图片(默认不过滤)
     *
     * @param filterGif
     * @return
     */
    fun filterGif(filterGif: Boolean): ImagePicker {
        ConfigManager.setFilterGif(filterGif)
        return this
    }


    /**
     * 图片最大选择数
     *
     * @param maxCount
     * @return
     */
    fun setMaxCount(maxCount: Int): ImagePicker {
        ConfigManager.setMaxCount(maxCount)
        return this
    }

    /**
     * 设置单类型选择（只能选图片或者视频）
     *
     * @param isSingleType
     * @return
     */
    fun setSingleType(isSingleType: Boolean): ImagePicker {
        ConfigManager.setSingleType(isSingleType)
        return this
    }


    /**
     * 设置图片加载器
     *
     * @param imageLoader
     * @return
     */
    fun setImageLoader(imageLoader: ImageLoader): ImagePicker {
        ConfigManager.setImageLoader(imageLoader)
        return this
    }

    /**
     * 设置图片选择历史记录
     *
     * @param imagePaths
     * @return
     */
    fun setImagePaths(imagePaths: ArrayList<String>): ImagePicker {
        ConfigManager.setImagePaths(imagePaths)
        return this
    }

    /**
     * 启动
     *
     * @param activity
     */
    fun start(activity: Activity, requestCode: Int) {
        val intent = Intent(activity, ImagePickerActivity::class.java)
        activity.startActivityForResult(intent, requestCode)
    }
}