/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.value.FontSpecification;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.util.XRLog;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class PdfBoxFontResolver
implements FontResolver {
    private Map<String, FontFamily> _fontFamilies = PdfBoxFontResolver.createInitialFontMap();
    private Map<String, FontDescription> _fontCache = new HashMap<String, FontDescription>();
    private final PDDocument _doc;
    private final SharedContext _sharedContext;

    public PdfBoxFontResolver(SharedContext sharedContext, PDDocument doc) {
        this._sharedContext = sharedContext;
        this._doc = doc;
    }

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(renderingContext, spec.families, spec.size, spec.fontWeight, spec.fontStyle, spec.variant);
    }

    @Deprecated
    public void flushCache() {
        this._fontFamilies = PdfBoxFontResolver.createInitialFontMap();
        this._fontCache = new HashMap<String, FontDescription>();
    }

    @Deprecated
    public void flushFontFaceFonts() {
        this._fontCache = new HashMap<String, FontDescription>();
        Iterator<FontFamily> i = this._fontFamilies.values().iterator();
        while (i.hasNext()) {
            FontFamily family = i.next();
            Iterator j = family.getFontDescriptions().iterator();
            while (j.hasNext()) {
                FontDescription d = (FontDescription)j.next();
                if (!d.isFromFontFace()) continue;
                j.remove();
            }
            if (family.getFontDescriptions().size() != 0) continue;
            i.remove();
        }
    }

    public void importFontFaces(List<FontFaceRule> fontFaces) {
        for (FontFaceRule rule : fontFaces) {
            CalculatedStyle style = rule.getCalculatedStyle();
            FSDerivedValue src = style.valueByName(CSSName.SRC);
            if (src == IdentValue.NONE) continue;
            boolean noSubset = style.isIdent(CSSName.FS_FONT_SUBSET, IdentValue.COMPLETE_FONT);
            String fontFamily = null;
            IdentValue fontWeight = null;
            IdentValue fontStyle = null;
            if (!rule.hasFontFamily()) {
                XRLog.cssParse((Level)Level.WARNING, (String)"Must provide at least a font-family and src in @font-face rule");
                continue;
            }
            fontFamily = style.valueByName(CSSName.FONT_FAMILY).asString();
            if (rule.hasFontWeight()) {
                fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
            }
            if (rule.hasFontStyle()) {
                fontStyle = style.getIdent(CSSName.FONT_STYLE);
            }
            this.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString(), !noSubset);
        }
    }

    public void addFontDirectory(String dir, boolean embedded) throws IOException {
        File f = new File(dir);
        if (f.isDirectory()) {
            File[] files = f.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lower = name.toLowerCase(Locale.US);
                    return lower.endsWith(".ttf");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                this.addFont(new FontFileFontSupplier(files[i].getAbsolutePath()), files[i].getName(), 400, IdentValue.NORMAL, true);
            }
        }
    }

    public void addFont(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        FontFamily fontFamily = this.getFontFamily(fontFamilyNameOverride);
        FontDescription descr = new FontDescription(this._doc, supplier, fontWeightOverride != null ? fontWeightOverride : 400, fontStyleOverride != null ? fontStyleOverride : IdentValue.NORMAL);
        if (!subset) {
            if (descr.realizeFont(subset)) {
                fontFamily.addFontDescription(descr);
            }
        } else {
            fontFamily.addFontDescription(descr);
        }
    }

    private void addFontFaceFont(String fontFamilyNameOverride, IdentValue fontWeightOverride, IdentValue fontStyleOverride, String uri, boolean subset) {
        FontFaceFontSupplier fontSupplier = new FontFaceFontSupplier(this._sharedContext, uri);
        FontFamily fontFamily = this.getFontFamily(fontFamilyNameOverride);
        FontDescription descr = new FontDescription(this._doc, fontSupplier, fontWeightOverride != null ? PdfBoxFontResolver.convertWeightToInt(fontWeightOverride) : 400, fontStyleOverride != null ? fontStyleOverride : IdentValue.NORMAL);
        descr.setFromFontFace(true);
        if (!subset) {
            if (descr.realizeFont(subset)) {
                fontFamily.addFontDescription(descr);
            }
        } else {
            fontFamily.addFontDescription(descr);
        }
    }

    private FontFamily getFontFamily(String fontFamilyName) {
        FontFamily fontFamily = this._fontFamilies.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily();
            fontFamily.setName(fontFamilyName);
            this._fontFamilies.put(fontFamilyName, fontFamily);
        }
        return fontFamily;
    }

    private FSFont resolveFont(SharedContext ctx, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        if (style != IdentValue.NORMAL && style != IdentValue.OBLIQUE && style != IdentValue.ITALIC) {
            style = IdentValue.NORMAL;
        }
        ArrayList<FontDescription> fonts = new ArrayList<FontDescription>(3);
        if (families != null) {
            for (int i = 0; i < families.length; ++i) {
                FontDescription font = this.resolveFont(ctx, families[i], size, weight, style, variant);
                if (font == null || !font.realizeFont(true)) continue;
                fonts.add(font);
            }
        }
        fonts.add(this.resolveFont(ctx, "Serif", size, weight, style, variant));
        return new PdfBoxFSFont(fonts, size);
    }

    private String normalizeFontFamily(String fontFamily) {
        String result = fontFamily;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.equalsIgnoreCase("serif")) {
            result = "Serif";
        } else if (result.equalsIgnoreCase("sans-serif")) {
            result = "SansSerif";
        } else if (result.equalsIgnoreCase("monospace")) {
            result = "Monospaced";
        }
        return result;
    }

    private FontDescription resolveFont(SharedContext ctx, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        String normalizedFontFamily = this.normalizeFontFamily(fontFamily);
        String cacheKey = PdfBoxFontResolver.getHashName(normalizedFontFamily, weight, style);
        FontDescription result = this._fontCache.get(cacheKey);
        if (result != null) {
            return result;
        }
        FontFamily family = this._fontFamilies.get(normalizedFontFamily);
        if (family != null && (result = family.match(PdfBoxFontResolver.convertWeightToInt(weight), style)) != null) {
            this._fontCache.put(cacheKey, result);
            return result;
        }
        return null;
    }

    private static int convertWeightToInt(IdentValue weight) {
        if (weight == IdentValue.NORMAL) {
            return 400;
        }
        if (weight == IdentValue.BOLD) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_100) {
            return 100;
        }
        if (weight == IdentValue.FONT_WEIGHT_200) {
            return 200;
        }
        if (weight == IdentValue.FONT_WEIGHT_300) {
            return 300;
        }
        if (weight == IdentValue.FONT_WEIGHT_400) {
            return 400;
        }
        if (weight == IdentValue.FONT_WEIGHT_500) {
            return 500;
        }
        if (weight == IdentValue.FONT_WEIGHT_600) {
            return 600;
        }
        if (weight == IdentValue.FONT_WEIGHT_700) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_800) {
            return 800;
        }
        if (weight == IdentValue.FONT_WEIGHT_900) {
            return 900;
        }
        if (weight == IdentValue.LIGHTER) {
            return 400;
        }
        if (weight == IdentValue.BOLDER) {
            return 700;
        }
        throw new IllegalArgumentException();
    }

    protected static String getHashName(String name, IdentValue weight, IdentValue style) {
        return name + "-" + weight + "-" + style;
    }

    private static Map<String, FontFamily> createInitialFontMap() {
        HashMap<String, FontFamily> result = new HashMap<String, FontFamily>();
        try {
            PdfBoxFontResolver.addCourier(result);
            PdfBoxFontResolver.addTimes(result);
            PdfBoxFontResolver.addHelvetica(result);
            PdfBoxFontResolver.addSymbol(result);
            PdfBoxFontResolver.addZapfDingbats(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    private static PDFont createFont(PDFont font) throws IOException {
        return font;
    }

    private static void addCourier(HashMap<String, FontFamily> result) throws IOException {
        FontFamily courier = new FontFamily();
        courier.setName("Courier");
        courier.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.COURIER_BOLD_OBLIQUE), IdentValue.OBLIQUE, 700));
        courier.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.COURIER_OBLIQUE), IdentValue.OBLIQUE, 400));
        courier.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.COURIER_BOLD), IdentValue.NORMAL, 700));
        courier.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.COURIER), IdentValue.NORMAL, 400));
        result.put("DialogInput", courier);
        result.put("Monospaced", courier);
        result.put("Courier", courier);
    }

    private static void addTimes(HashMap<String, FontFamily> result) throws IOException {
        FontFamily times = new FontFamily();
        times.setName("Times");
        times.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.TIMES_BOLD_ITALIC), IdentValue.ITALIC, 700));
        times.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.TIMES_ITALIC), IdentValue.ITALIC, 400));
        times.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.TIMES_BOLD), IdentValue.NORMAL, 700));
        times.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.TIMES_ROMAN), IdentValue.NORMAL, 400));
        result.put("Serif", times);
        result.put("TimesRoman", times);
    }

    private static void addHelvetica(HashMap<String, FontFamily> result) throws IOException {
        FontFamily helvetica = new FontFamily();
        helvetica.setName("Helvetica");
        helvetica.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.HELVETICA_BOLD_OBLIQUE), IdentValue.OBLIQUE, 700));
        helvetica.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.HELVETICA_OBLIQUE), IdentValue.OBLIQUE, 400));
        helvetica.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.HELVETICA_BOLD), IdentValue.NORMAL, 700));
        helvetica.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.HELVETICA), IdentValue.NORMAL, 400));
        result.put("Dialog", helvetica);
        result.put("SansSerif", helvetica);
        result.put("Helvetica", helvetica);
    }

    private static void addSymbol(Map<String, FontFamily> result) throws IOException {
        FontFamily fontFamily = new FontFamily();
        fontFamily.setName("Symbol");
        fontFamily.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.SYMBOL), IdentValue.NORMAL, 400));
        result.put("Symbol", fontFamily);
    }

    private static void addZapfDingbats(Map<String, FontFamily> result) throws IOException {
        FontFamily fontFamily = new FontFamily();
        fontFamily.setName("ZapfDingbats");
        fontFamily.addFontDescription(new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.ZAPF_DINGBATS), IdentValue.NORMAL, 400));
        result.put("ZapfDingbats", fontFamily);
    }

    public static class FontDescription {
        private final IdentValue _style;
        private final int _weight;
        private final PDDocument _doc;
        private FSSupplier<InputStream> _supplier;
        private PDFont _font;
        private float _underlinePosition;
        private float _underlineThickness;
        private float _yStrikeoutSize;
        private float _yStrikeoutPosition;
        private boolean _isFromFontFace;

        private FontDescription(PDFont font, IdentValue style, int weight) {
            this(null, font, style, weight);
        }

        public FontDescription(PDDocument doc, PDFont font) {
            this(doc, font, IdentValue.NORMAL, 400);
        }

        private FontDescription(PDDocument doc, FSSupplier<InputStream> supplier, int weight, IdentValue style) {
            this._supplier = supplier;
            this._weight = weight;
            this._style = style;
            this._doc = doc;
        }

        private FontDescription(PDDocument doc, PDFont font, IdentValue style, int weight) {
            this._font = font;
            this._style = style;
            this._weight = weight;
            this._supplier = null;
            this._doc = doc;
            this.setMetricDefaults();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean realizeFont(boolean subset) {
            if (this._font == null && this._supplier != null) {
                InputStream is = (InputStream)this._supplier.supply();
                this._supplier = null;
                if (is == null) {
                    return false;
                }
                try {
                    this._font = PDType0Font.load((PDDocument)this._doc, (InputStream)is, (boolean)subset);
                }
                catch (IOException e) {
                    XRLog.exception((String)"Couldn't load font. Please check that it is a valid truetype font.");
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                PDFontDescriptor descriptor = this._font.getFontDescriptor();
                this.setUnderlinePosition(descriptor.getDescent());
                this.setYStrikeoutPosition(descriptor.getFontBoundingBox().getUpperRightY() / 3.0f);
                this.setYStrikeoutSize(100.0f);
                this.setUnderlineThickness(50.0f);
            }
            return this._font != null;
        }

        public PDFont getFont() {
            return this._font;
        }

        public void setFont(PDFont font) {
            this._font = font;
        }

        public int getWeight() {
            return this._weight;
        }

        public IdentValue getStyle() {
            return this._style;
        }

        public float getUnderlinePosition() {
            return this._underlinePosition;
        }

        public void setUnderlinePosition(float underlinePosition) {
            this._underlinePosition = underlinePosition;
        }

        public float getUnderlineThickness() {
            return this._underlineThickness;
        }

        public void setUnderlineThickness(float underlineThickness) {
            this._underlineThickness = underlineThickness;
        }

        public float getYStrikeoutPosition() {
            return this._yStrikeoutPosition;
        }

        public void setYStrikeoutPosition(float strikeoutPosition) {
            this._yStrikeoutPosition = strikeoutPosition;
        }

        public float getYStrikeoutSize() {
            return this._yStrikeoutSize;
        }

        public void setYStrikeoutSize(float strikeoutSize) {
            this._yStrikeoutSize = strikeoutSize;
        }

        private void setMetricDefaults() {
            this._underlinePosition = -50.0f;
            this._underlineThickness = 50.0f;
            float boxHeight = this._font.getFontDescriptor().getXHeight();
            this._yStrikeoutPosition = boxHeight / 2.0f + 50.0f;
            this._yStrikeoutSize = 100.0f;
        }

        public boolean isFromFontFace() {
            return this._isFromFontFace;
        }

        public void setFromFontFace(boolean isFromFontFace) {
            this._isFromFontFace = isFromFontFace;
        }
    }

    private static class FontFamily {
        private List<FontDescription> _fontDescriptions;
        private static final int SM_EXACT = 1;
        private static final int SM_LIGHTER_OR_DARKER = 2;
        private static final int SM_DARKER_OR_LIGHTER = 3;

        private FontFamily() {
        }

        private List<FontDescription> getFontDescriptions() {
            return this._fontDescriptions;
        }

        private void addFontDescription(FontDescription descr) {
            if (this._fontDescriptions == null) {
                this._fontDescriptions = new ArrayList<FontDescription>();
            }
            this._fontDescriptions.add(descr);
            Collections.sort(this._fontDescriptions, new Comparator<FontDescription>(){

                @Override
                public int compare(FontDescription o1, FontDescription o2) {
                    return o1.getWeight() - o2.getWeight();
                }
            });
        }

        private void setName(String name) {
        }

        private FontDescription match(int desiredWeight, IdentValue style) {
            FontDescription[] matches;
            FontDescription result;
            if (this._fontDescriptions == null) {
                throw new RuntimeException("fontDescriptions is null");
            }
            ArrayList<FontDescription> candidates = new ArrayList<FontDescription>();
            for (FontDescription description : this._fontDescriptions) {
                if (description.getStyle() != style) continue;
                candidates.add(description);
            }
            if (candidates.size() == 0) {
                if (style == IdentValue.ITALIC) {
                    return this.match(desiredWeight, IdentValue.OBLIQUE);
                }
                if (style == IdentValue.OBLIQUE) {
                    return this.match(desiredWeight, IdentValue.NORMAL);
                }
                candidates.addAll(this._fontDescriptions);
            }
            if ((result = this.findByWeight(matches = candidates.toArray(new FontDescription[candidates.size()]), desiredWeight, 1)) != null) {
                return result;
            }
            if (desiredWeight <= 500) {
                return this.findByWeight(matches, desiredWeight, 2);
            }
            return this.findByWeight(matches, desiredWeight, 3);
        }

        private FontDescription findByWeight(FontDescription[] matches, int desiredWeight, int searchMode) {
            if (searchMode == 1) {
                for (int i = 0; i < matches.length; ++i) {
                    FontDescription descr = matches[i];
                    if (descr.getWeight() != desiredWeight) continue;
                    return descr;
                }
                return null;
            }
            if (searchMode == 2) {
                int offset = 0;
                FontDescription descr = null;
                for (offset = 0; offset < matches.length && (descr = matches[offset]).getWeight() <= desiredWeight; ++offset) {
                }
                if (offset > 0 && descr.getWeight() > desiredWeight) {
                    return matches[offset - 1];
                }
                return descr;
            }
            if (searchMode == 3) {
                int offset = 0;
                FontDescription descr = null;
                for (offset = matches.length - 1; offset >= 0 && (descr = matches[offset]).getWeight() >= desiredWeight; --offset) {
                }
                if (offset != matches.length - 1 && descr.getWeight() < desiredWeight) {
                    return matches[offset + 1];
                }
                return descr;
            }
            return null;
        }
    }

    private static class FontFileFontSupplier
    implements FSSupplier<InputStream> {
        private final String path;

        FontFileFontSupplier(String path) {
            this.path = path;
        }

        public InputStream supply() {
            try {
                return new FileInputStream(this.path);
            }
            catch (FileNotFoundException e) {
                XRLog.exception((String)"While trying to add font from directory, file seems to have disappeared.");
                return null;
            }
        }
    }

    private static class FontFaceFontSupplier
    implements FSSupplier<InputStream> {
        private final String src;
        private final SharedContext ctx;

        private FontFaceFontSupplier(SharedContext ctx, String src) {
            this.src = src;
            this.ctx = ctx;
        }

        public InputStream supply() {
            byte[] font1 = this.ctx.getUserAgentCallback().getBinaryResource(this.src);
            if (font1 == null) {
                XRLog.exception((String)("Could not load @font-face font: " + this.src));
                return null;
            }
            return new ByteArrayInputStream(font1);
        }
    }
}

