/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.FSCMYKColor;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.pdfboxout.DOMUtil;
import com.openhtmltopdf.pdfboxout.PdfBoxLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.XRLog;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionResetForm;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSubmitForm;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDComboBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDListBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDRadioButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.w3c.dom.Element;

public class PdfBoxForm {
    private final Element element;
    private final List<ControlFontPair> controls = new ArrayList<ControlFontPair>();
    private final List<String> controlNames = new ArrayList<String>();
    private final List<Control> submits = new ArrayList<Control>(2);
    private final Map<String, List<Control>> radioGroups = new LinkedHashMap<String, List<Control>>();

    private PdfBoxForm(Element element) {
        this.element = element;
    }

    public static PdfBoxForm createForm(Element e) {
        return new PdfBoxForm(e);
    }

    public void addControl(Control ctrl, String fontName) {
        this.controls.add(new ControlFontPair(ctrl, fontName));
    }

    private static Integer getNumber(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String getColorOperator(FSColor color) {
        String colorOperator = "";
        if (color instanceof FSRGBColor) {
            FSRGBColor rgb = (FSRGBColor)color;
            float r = (float)rgb.getRed() / 255.0f;
            float g = (float)rgb.getGreen() / 255.0f;
            float b = (float)rgb.getBlue() / 255.0f;
            colorOperator = String.format(Locale.US, "%.4f", Float.valueOf(r)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(g)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(b)) + ' ' + "rg";
        } else if (color instanceof FSCMYKColor) {
            FSCMYKColor cmyk = (FSCMYKColor)color;
            float c = cmyk.getCyan();
            float m = cmyk.getMagenta();
            float y = cmyk.getYellow();
            float k = cmyk.getBlack();
            colorOperator = String.format(Locale.US, "%.4f", Float.valueOf(c)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(m)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(y)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(k)) + ' ' + "k";
        }
        return colorOperator;
    }

    private String getTextareaText(Element e) {
        return DOMUtil.getText(e);
    }

    private String populateOptions(Element e, List<String> labels, List<String> values, List<Integer> selectedIndices) {
        List<Element> opts = DOMUtil.getChildren(e, "option");
        String selected = "";
        int i = 0;
        for (Element opt : opts) {
            String label = DOMUtil.getText(opt);
            labels.add(label);
            if (opt.hasAttribute("value")) {
                values.add(opt.getAttribute("value"));
            } else {
                values.add(label);
            }
            if (selected.isEmpty()) {
                selected = label;
            }
            if (opt.hasAttribute("selected")) {
                selected = label;
            }
            if (opt.hasAttribute("selected") && selectedIndices != null) {
                selectedIndices.add(i);
            }
            ++i;
        }
        return selected;
    }

    private void processMultiSelectControl(ControlFontPair pair, Control ctrl, PDAcroForm acro, int i, Box root, PdfBoxOutputDevice od) throws IOException {
        PDListBox field = new PDListBox(acro);
        field.setPartialName("OpenHTMLCtrl" + i);
        this.controlNames.add("OpenHTMLCtrl" + i);
        field.setMappingName(ctrl.box.getElement().getAttribute("name"));
        field.setMultiSelect(true);
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<Integer> selected = new ArrayList<Integer>();
        this.populateOptions(ctrl.box.getElement(), labels, values, selected);
        field.setOptions(values, labels);
        field.setSelectedOptionsIndex(selected);
        FSColor color = ctrl.box.getStyle().getColor();
        String colorOperator = PdfBoxForm.getColorOperator(color);
        String fontInstruction = "/" + pair.fontName + " 0 Tf";
        field.setDefaultAppearance(fontInstruction + ' ' + colorOperator);
        if (ctrl.box.getElement().hasAttribute("required")) {
            field.setRequired(true);
        }
        if (ctrl.box.getElement().hasAttribute("readonly")) {
            field.setReadOnly(true);
        }
        if (ctrl.box.getElement().hasAttribute("title")) {
            field.setAlternateFieldName(ctrl.box.getElement().getAttribute("title"));
        }
        PDAnnotationWidget widget = (PDAnnotationWidget)field.getWidgets().get(0);
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        widget.setPrinted(true);
        ctrl.page.getAnnotations().add(widget);
        acro.getFields().add(field);
    }

    private void processSelectControl(ControlFontPair pair, Control ctrl, PDAcroForm acro, int i, Box root, PdfBoxOutputDevice od) throws IOException {
        PDComboBox field = new PDComboBox(acro);
        field.setPartialName("OpenHTMLCtrl" + i);
        this.controlNames.add("OpenHTMLCtrl" + i);
        field.setMappingName(ctrl.box.getElement().getAttribute("name"));
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String selectedLabel = this.populateOptions(ctrl.box.getElement(), labels, values, null);
        field.setOptions(values, labels);
        field.setValue(selectedLabel);
        field.setDefaultValue(selectedLabel);
        FSColor color = ctrl.box.getStyle().getColor();
        String colorOperator = PdfBoxForm.getColorOperator(color);
        String fontInstruction = "/" + pair.fontName + " 0 Tf";
        field.setDefaultAppearance(fontInstruction + ' ' + colorOperator);
        if (ctrl.box.getElement().hasAttribute("required")) {
            field.setRequired(true);
        }
        if (ctrl.box.getElement().hasAttribute("readonly")) {
            field.setReadOnly(true);
        }
        if (ctrl.box.getElement().hasAttribute("title")) {
            field.setAlternateFieldName(ctrl.box.getElement().getAttribute("title"));
        }
        if (ctrl.box.getElement().getNodeName().equals("openhtmltopdf-combo")) {
            field.setEdit(true);
            field.setCombo(true);
        }
        PDAnnotationWidget widget = (PDAnnotationWidget)field.getWidgets().get(0);
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        widget.setPrinted(true);
        ctrl.page.getAnnotations().add(widget);
        acro.getFields().add(field);
    }

    private void processTextControl(ControlFontPair pair, Control ctrl, PDAcroForm acro, int i, Box root, PdfBoxOutputDevice od) throws IOException {
        PDTextField field = new PDTextField(acro);
        FSColor color = ctrl.box.getStyle().getColor();
        String colorOperator = PdfBoxForm.getColorOperator(color);
        String fontInstruction = "/" + pair.fontName + " 0 Tf";
        field.setDefaultAppearance(fontInstruction + ' ' + colorOperator);
        field.setPartialName("OpenHTMLCtrl" + i);
        this.controlNames.add("OpenHTMLCtrl" + i);
        String value = ctrl.box.getElement().getNodeName().equals("textarea") ? this.getTextareaText(ctrl.box.getElement()) : ctrl.box.getElement().getAttribute("value");
        field.setDefaultValue(value);
        field.setValue(value);
        if (PdfBoxForm.getNumber(ctrl.box.getElement().getAttribute("max-length")) != null) {
            field.setMaxLen(PdfBoxForm.getNumber(ctrl.box.getElement().getAttribute("max-length")).intValue());
        }
        if (ctrl.box.getElement().hasAttribute("required")) {
            field.setRequired(true);
        }
        if (ctrl.box.getElement().hasAttribute("readonly")) {
            field.setReadOnly(true);
        }
        if (ctrl.box.getElement().getNodeName().equals("textarea")) {
            field.setMultiline(true);
        } else if (ctrl.box.getElement().getAttribute("type").equals("password")) {
            field.setPassword(true);
        } else if (ctrl.box.getElement().getAttribute("type").equals("file")) {
            XRLog.general((Level)Level.WARNING, (String)"Acrobat Reader does not support forms with file input controls");
            field.setFileSelect(true);
        }
        field.setMappingName(ctrl.box.getElement().getAttribute("name"));
        if (ctrl.box.getElement().hasAttribute("title")) {
            field.setAlternateFieldName(ctrl.box.getElement().getAttribute("title"));
        }
        PDAnnotationWidget widget = (PDAnnotationWidget)field.getWidgets().get(0);
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        widget.setPrinted(true);
        ctrl.page.getAnnotations().add(widget);
        acro.getFields().add(field);
    }

    public static PDAppearanceStream createCheckboxAppearance(CheckboxStyle style, PDDocument doc, PDResources resources) {
        String appear = "q\nBT\n1 0 0 1 15 20 Tm\n/OpenHTMLZap 100 Tf\n(" + (char)style.caption + ") Tj\nET\nQ\n";
        return PdfBoxForm.createCheckboxAppearance(appear, doc, resources);
    }

    public static PDAppearanceStream createCheckboxAppearance(String appear, PDDocument doc, PDResources resources) {
        PDAppearanceStream s = new PDAppearanceStream(doc);
        s.setBBox(new PDRectangle(100.0f, 100.0f));
        OutputStream os = null;
        try {
            os = s.getContentStream().createOutputStream();
            os.write(appear.getBytes("ASCII"));
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("createCheckboxAppearance", e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
        s.setResources(resources);
        return s;
    }

    private COSString getCOSStringUTF16Encoded(String value) throws UnsupportedEncodingException {
        byte[] data = value.getBytes("UTF-16BE");
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 2);
        out.write(254);
        out.write(255);
        try {
            out.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = out.toByteArray();
        COSString valueEncoded = new COSString(bytes);
        return valueEncoded;
    }

    private void processCheckboxControl(ControlFontPair pair, PDAcroForm acro, int i, Control ctrl, Box root, PdfBoxOutputDevice od) throws IOException {
        PDCheckBox field = new PDCheckBox(acro);
        field.setPartialName("OpenHTMLCtrl" + i);
        this.controlNames.add("OpenHTMLCtrl" + i);
        if (ctrl.box.getElement().hasAttribute("required")) {
            field.setRequired(true);
        }
        if (ctrl.box.getElement().hasAttribute("readonly")) {
            field.setReadOnly(true);
        }
        field.setMappingName(ctrl.box.getElement().getAttribute("name"));
        COSArray arr = new COSArray();
        arr.add((COSBase)this.getCOSStringUTF16Encoded(ctrl.box.getElement().getAttribute("value")));
        field.getCOSObject().setItem(COSName.OPT, (COSBase)arr);
        if (ctrl.box.getElement().hasAttribute("title")) {
            field.setAlternateFieldName(ctrl.box.getElement().getAttribute("title"));
        }
        COSName zero = COSName.getPDFName((String)"0");
        if (ctrl.box.getElement().hasAttribute("checked")) {
            field.getCOSObject().setItem(COSName.AS, (COSBase)zero);
            field.getCOSObject().setItem(COSName.V, (COSBase)zero);
            field.getCOSObject().setItem(COSName.DV, (COSBase)zero);
        } else {
            field.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
            field.getCOSObject().setItem(COSName.V, (COSBase)COSName.Off);
            field.getCOSObject().setItem(COSName.DV, (COSBase)COSName.Off);
        }
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        PDAnnotationWidget widget = (PDAnnotationWidget)field.getWidgets().get(0);
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        widget.setPrinted(true);
        CheckboxStyle style = CheckboxStyle.fromIdent(ctrl.box.getStyle().getIdent(CSSName.FS_CHECKBOX_STYLE));
        PDAppearanceCharacteristicsDictionary appearanceCharacteristics = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
        appearanceCharacteristics.setNormalCaption(String.valueOf((char)style.caption));
        widget.setAppearanceCharacteristics(appearanceCharacteristics);
        COSDictionary dict = new COSDictionary();
        dict.setItem(zero, (COSObjectable)od.checkboxAppearances.get((Object)style));
        dict.setItem(COSName.Off, (COSObjectable)od.checkboxOffAppearance);
        PDAppearanceDictionary appearanceDict = new PDAppearanceDictionary();
        appearanceDict.getCOSObject().setItem(COSName.N, (COSBase)dict);
        widget.setAppearance(appearanceDict);
        ctrl.page.getAnnotations().add(widget);
        acro.getFields().add(field);
    }

    private void processRadioButtonGroup(List<Control> group, PDAcroForm acro, int i, Box root, PdfBoxOutputDevice od) throws IOException {
        String groupName = group.get((int)0).box.getElement().getAttribute("name");
        PDRadioButton field = new PDRadioButton(acro);
        field.setPartialName("OpenHTMLCtrl" + i);
        this.controlNames.add("OpenHTMLCtrl" + i);
        field.setMappingName(groupName);
        ArrayList<String> values = new ArrayList<String>(group.size());
        for (Control ctrl : group) {
            values.add(ctrl.box.getElement().getAttribute("value"));
        }
        field.setExportValues(values);
        ArrayList<PDAnnotationWidget> widgets = new ArrayList<PDAnnotationWidget>(group.size());
        int radioCnt = 0;
        for (Control ctrl : group) {
            Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, od);
            PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
            PDAnnotationWidget widget = new PDAnnotationWidget();
            widget.setRectangle(rect);
            widget.setPage(ctrl.page);
            widget.setPrinted(true);
            COSDictionary dict = new COSDictionary();
            dict.setItem(COSName.getPDFName((String)("" + radioCnt)), (COSObjectable)od.radioBoxOnAppearance);
            dict.setItem(COSName.Off, (COSObjectable)od.radioBoxOffAppearance);
            PDAppearanceDictionary appearanceDict = new PDAppearanceDictionary();
            appearanceDict.getCOSObject().setItem(COSName.N, (COSBase)dict);
            if (ctrl.box.getElement().hasAttribute("checked")) {
                widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.getPDFName((String)("" + radioCnt)));
            } else {
                widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
            }
            widget.setAppearance(appearanceDict);
            widgets.add(widget);
            ctrl.page.getAnnotations().add(widget);
            ++radioCnt;
        }
        field.setWidgets(widgets);
        for (Control ctrl : group) {
            if (!ctrl.box.getElement().hasAttribute("checked")) continue;
            field.setValue(ctrl.box.getElement().getAttribute("value"));
        }
        acro.getFields().add(field);
    }

    private void processSubmitControl(PDAcroForm acro, int i, Control ctrl, Box root, PdfBoxOutputDevice od) throws IOException {
        int FLAG_USE_GET = 8;
        int FLAG_USE_HTML_SUBMIT = 4;
        PDPushButton btn = new PDPushButton(acro);
        btn.setPushButton(true);
        btn.setPartialName("OpenHTMLCtrl" + i);
        PDAnnotationWidget widget = (PDAnnotationWidget)btn.getWidgets().get(0);
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        COSArrayList fieldsToInclude = new COSArrayList();
        fieldsToInclude.addAll(this.controlNames);
        if (ctrl.box.getElement().getAttribute("type").equals("reset")) {
            PDActionResetForm reset = new PDActionResetForm();
            reset.setFields(fieldsToInclude.toList());
            widget.setAction((PDAction)reset);
        } else {
            PDFileSpecification fs = PDFileSpecification.createFS((COSBase)new COSString(this.element.getAttribute("action")));
            PDActionSubmitForm submit = new PDActionSubmitForm();
            submit.setFields(fieldsToInclude.toList());
            submit.setFile(fs);
            if (!this.element.getAttribute("method").equalsIgnoreCase("post")) {
                XRLog.general((Level)Level.WARNING, (String)"Using GET request method for form. You probably meant to add a method=\"post\" attribute to your form");
                submit.setFlags(12);
            } else {
                submit.setFlags(4);
            }
            widget.setAction((PDAction)submit);
        }
        ctrl.page.getAnnotations().add(widget);
        acro.getFields().add(btn);
    }

    public int process(PDAcroForm acro, int startId, Box root, PdfBoxOutputDevice od) throws IOException {
        int i = startId;
        for (ControlFontPair controlFontPair : this.controls) {
            ++i;
            Control ctrl = controlFontPair.control;
            Element e = ctrl.box.getElement();
            if (e.getNodeName().equals("input") && e.getAttribute("type").equals("text") || e.getNodeName().equals("textarea") || e.getNodeName().equals("input") && e.getAttribute("type").equals("password") || e.getNodeName().equals("input") && e.getAttribute("type").equals("file")) {
                this.processTextControl(controlFontPair, ctrl, acro, i, root, od);
                continue;
            }
            if (e.getNodeName().equals("select") && !e.hasAttribute("multiple") || e.getNodeName().equals("openhtmltopdf-combo")) {
                this.processSelectControl(controlFontPair, ctrl, acro, i, root, od);
                continue;
            }
            if (e.getNodeName().equals("select") && e.hasAttribute("multiple")) {
                this.processMultiSelectControl(controlFontPair, ctrl, acro, i, root, od);
                continue;
            }
            if (e.getNodeName().equals("input") && e.getAttribute("type").equals("checkbox")) {
                this.processCheckboxControl(controlFontPair, acro, i, ctrl, root, od);
                continue;
            }
            if (e.getNodeName().equals("input") && e.getAttribute("type").equals("radio")) {
                List<Control> radioGroup = this.radioGroups.get(e.getAttribute("name"));
                if (radioGroup == null) {
                    radioGroup = new ArrayList<Control>();
                    this.radioGroups.put(e.getAttribute("name"), radioGroup);
                }
                radioGroup.add(ctrl);
                continue;
            }
            if (!(e.getNodeName().equals("input") && e.getAttribute("type").equals("submit") || e.getNodeName().equals("button") && !e.getAttribute("type").equals("button")) && (!e.getNodeName().equals("input") || !e.getAttribute("type").equals("reset"))) continue;
            this.submits.add(ctrl);
        }
        for (List list : this.radioGroups.values()) {
            this.processRadioButtonGroup(list, acro, ++i, root, od);
        }
        for (Control control : this.submits) {
            this.processSubmitControl(acro, ++i, control, root, od);
        }
        return i;
    }

    public static enum CheckboxStyle {
        CHECK(52),
        CROSS(53),
        DIAMOND(117),
        CIRCLE(108),
        STAR(72),
        SQUARE(110);

        private final int caption;

        private CheckboxStyle(int caption) {
            this.caption = caption;
        }

        public static CheckboxStyle fromIdent(IdentValue id) {
            if (id == IdentValue.CHECK) {
                return CHECK;
            }
            if (id == IdentValue.CROSS) {
                return CROSS;
            }
            if (id == IdentValue.SQUARE) {
                return SQUARE;
            }
            if (id == IdentValue.CIRCLE) {
                return CIRCLE;
            }
            if (id == IdentValue.DIAMOND) {
                return DIAMOND;
            }
            if (id == IdentValue.STAR) {
                return STAR;
            }
            return CHECK;
        }
    }

    private static class ControlFontPair {
        private final String fontName;
        private final Control control;

        private ControlFontPair(Control control, String fontName) {
            this.control = control;
            this.fontName = fontName;
        }
    }

    public static class Control {
        public final Box box;
        private final PDPage page;
        private final AffineTransform transform;
        private final RenderingContext c;
        private final float pageHeight;

        public Control(Box box, PDPage page, AffineTransform transform, RenderingContext c, float pageHeight) {
            this.box = box;
            this.page = page;
            this.transform = transform;
            this.c = c;
            this.pageHeight = pageHeight;
        }
    }
}

