/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.extend.FSCache;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.HttpStreamFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.swing.NaiveUserAgent;
import java.io.File;
import java.io.OutputStream;
import org.w3c.dom.Document;

public class PdfRendererBuilder {
    private boolean _textDirection = false;
    private boolean _testMode = false;
    private boolean _useSubsets = true;
    private HttpStreamFactory _httpStreamFactory = new NaiveUserAgent.DefaultHttpStreamFactory();
    private BidiSplitterFactory _splitter;
    private BidiReorderer _reorderer;
    private String _html;
    private Document _document;
    private String _baseUri;
    private String _uri;
    private File _file;
    private OutputStream _os;
    private FSUriResolver _resolver;
    private FSCache _cache;
    private SVGDrawer _svgImpl;

    public void run() throws Exception {
        PdfBoxRenderer renderer = this.buildPdfRenderer();
        renderer.layout();
        renderer.createPDF();
    }

    public PdfBoxRenderer buildPdfRenderer() {
        return new PdfBoxRenderer(this._textDirection, this._testMode, this._useSubsets, this._httpStreamFactory, this._splitter, this._reorderer, this._html, this._document, this._baseUri, this._uri, this._file, this._os, this._resolver, this._cache, this._svgImpl);
    }

    public PdfRendererBuilder defaultTextDirection(TextDirection textDirection) {
        this._textDirection = textDirection == TextDirection.RTL;
        return this;
    }

    public PdfRendererBuilder testMode(boolean mode) {
        this._testMode = mode;
        return this;
    }

    public PdfRendererBuilder subsetFonts(boolean subset) {
        this._useSubsets = subset;
        return this;
    }

    public PdfRendererBuilder useHttpStreamImplementation(HttpStreamFactory factory) {
        this._httpStreamFactory = factory;
        return this;
    }

    public PdfRendererBuilder useUriResolver(FSUriResolver resolver) {
        this._resolver = resolver;
        return this;
    }

    public PdfRendererBuilder useCache(FSCache cache) {
        this._cache = cache;
        return this;
    }

    public PdfRendererBuilder useBidiSplitter(BidiSplitterFactory splitter) {
        this._splitter = splitter;
        return this;
    }

    public PdfRendererBuilder useBidiReorderer(BidiReorderer reorderer) {
        this._reorderer = reorderer;
        return this;
    }

    public PdfRendererBuilder withHtmlContent(String html, String baseUri) {
        this._html = html;
        this._baseUri = baseUri;
        return this;
    }

    public PdfRendererBuilder withW3cDocument(Document doc, String baseUri) {
        this._document = doc;
        this._baseUri = baseUri;
        return this;
    }

    public PdfRendererBuilder withUri(String uri) {
        this._uri = uri;
        return this;
    }

    public PdfRendererBuilder withFile(File file) {
        this._file = file;
        return this;
    }

    public PdfRendererBuilder toStream(OutputStream out) {
        this._os = out;
        return this;
    }

    public PdfRendererBuilder useSVGDrawer(SVGDrawer svgImpl) {
        this._svgImpl = svgImpl;
        return this;
    }

    public static enum TextDirection {
        RTL,
        LTR;

    }
}

