/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.extend.FSGlyphVector;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.FSFontMetrics;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.util.Configuration;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;

public class PdfBoxTextRenderer
implements TextRenderer {
    private static float TEXT_MEASURING_DELTA = 0.01f;
    private BidiReorderer _reorderer;

    public void setup(FontContext context, BidiReorderer reorderer) {
        this._reorderer = reorderer;
    }

    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        ((PdfBoxOutputDevice)outputDevice).drawString(string, x, y, null);
    }

    public void drawString(OutputDevice outputDevice, String string, float x, float y, JustificationInfo info) {
        ((PdfBoxOutputDevice)outputDevice).drawString(string, x, y, info);
    }

    public FSFontMetrics getFSFontMetrics(FontContext context, FSFont font, String string) {
        List<PdfBoxFontResolver.FontDescription> descrs = ((PdfBoxFSFont)font).getFontDescription();
        float size = font.getSize2D();
        PdfBoxFSFontMetrics result = new PdfBoxFSFontMetrics();
        try {
            float largestAscent = Float.MIN_VALUE;
            float largestDescent = Float.MIN_VALUE;
            float largestStrikethroughOffset = Float.MIN_VALUE;
            float largestStrikethroughThickness = Float.MIN_VALUE;
            float largestUnderlinePosition = Float.MIN_VALUE;
            float largestUnderlineThickness = Float.MIN_VALUE;
            for (PdfBoxFontResolver.FontDescription des : descrs) {
                float loopAscent = des.getFont().getBoundingBox().getUpperRightY();
                float loopDescent = -des.getFont().getBoundingBox().getLowerLeftY();
                float loopStrikethroughOffset = -des.getYStrikeoutPosition();
                float loopStrikethroughThickness = des.getYStrikeoutSize();
                float loopUnderlinePosition = -des.getUnderlinePosition();
                float loopUnderlineThickness = des.getUnderlineThickness();
                if (loopAscent > largestAscent) {
                    largestAscent = loopAscent;
                }
                if (loopDescent > largestDescent) {
                    largestDescent = loopDescent;
                }
                if (loopStrikethroughOffset > largestStrikethroughOffset) {
                    largestStrikethroughOffset = loopStrikethroughOffset;
                }
                if (loopStrikethroughThickness > largestStrikethroughThickness) {
                    largestStrikethroughThickness = loopStrikethroughThickness;
                }
                if (loopUnderlinePosition > largestUnderlinePosition) {
                    largestUnderlinePosition = loopUnderlinePosition;
                }
                if (!(loopUnderlineThickness > largestUnderlineThickness)) continue;
                largestUnderlineThickness = loopUnderlineThickness;
            }
            result.setAscent(largestAscent / 1000.0f * size);
            result.setDescent(largestDescent / 1000.0f * size);
            result.setStrikethroughOffset(largestStrikethroughOffset / 1000.0f * size);
            if (largestStrikethroughThickness > 0.0f) {
                result.setStrikethroughThickness(largestStrikethroughThickness / 1000.0f * size);
            } else {
                result.setStrikethroughThickness(size / 12.0f);
            }
            result.setUnderlineOffset(largestUnderlinePosition / 1000.0f * size);
            result.setUnderlineThickness(largestUnderlineThickness / 1000.0f * size);
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("getFSFontMetrics", e);
        }
        return result;
    }

    static ReplacementChar getReplacementChar(FSFont font) {
        char replacement = Configuration.valueAsChar((String)"xr.renderer.missing-character-replacement", (char)' ');
        String replaceStr = String.valueOf(replacement);
        List<PdfBoxFontResolver.FontDescription> descriptions = ((PdfBoxFSFont)font).getFontDescription();
        for (PdfBoxFontResolver.FontDescription des : descriptions) {
            try {
                float width = des.getFont().getStringWidth(replaceStr);
                ReplacementChar replace = new ReplacementChar();
                replace.replacement = replacement;
                replace.fontDescription = des;
                replace.width = width;
                return replace;
            }
            catch (Exception width) {
            }
        }
        replaceStr = " ";
        for (PdfBoxFontResolver.FontDescription des : descriptions) {
            try {
                float width = des.getFont().getStringWidth(replaceStr);
                ReplacementChar replace = new ReplacementChar();
                replace.replacement = (char)32;
                replace.fontDescription = des;
                replace.width = width;
                return replace;
            }
            catch (Exception exception) {
            }
        }
        ReplacementChar replace = new ReplacementChar();
        replace.replacement = (char)32;
        replace.fontDescription = descriptions.get(0);
        replace.width = 0.0f;
        return replace;
    }

    private float getStringWidthSlow(FSFont bf, String str) {
        ReplacementChar replace = PdfBoxTextRenderer.getReplacementChar(bf);
        List<PdfBoxFontResolver.FontDescription> fonts = ((PdfBoxFSFont)bf).getFontDescription();
        float strWidthResult = 0.0f;
        int i = 0;
        while (i < str.length()) {
            int unicode = str.codePointAt(i);
            i += Character.charCount(unicode);
            String ch = String.valueOf(Character.toChars(unicode));
            boolean gotWidth = false;
            for (PdfBoxFontResolver.FontDescription des : fonts) {
                try {
                    strWidthResult += des.getFont().getStringWidth(ch);
                    gotWidth = true;
                    break;
                }
                catch (Exception e1) {
                    if (!this._reorderer.isLiveImplementation()) continue;
                    String deshaped = this._reorderer.deshapeText(ch);
                    try {
                        strWidthResult += des.getFont().getStringWidth(deshaped);
                        gotWidth = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (gotWidth) continue;
            strWidthResult += replace.width;
        }
        return strWidthResult;
    }

    public int getWidth(FontContext context, FSFont font, String string) {
        float result = 0.0f;
        try {
            result = ((PdfBoxFSFont)font).getFontDescription().get(0).getFont().getStringWidth(string) / 1000.0f * font.getSize2D();
        }
        catch (IllegalArgumentException e2) {
            result = this.getStringWidthSlow(font, string) / 1000.0f * font.getSize2D();
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("getWidth", e);
        }
        if ((double)result - Math.floor(result) < (double)TEXT_MEASURING_DELTA) {
            return (int)result;
        }
        return (int)Math.ceil(result);
    }

    public void setFontScale(float scale) {
        throw new UnsupportedOperationException();
    }

    public float getFontScale() {
        return 1.0f;
    }

    public void setSmoothingThreshold(float fontsize) {
    }

    public int getSmoothingLevel() {
        return 0;
    }

    public void setSmoothingLevel(int level) {
    }

    public Rectangle getGlyphBounds(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector, int index, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public float[] getGlyphPositions(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector) {
        throw new UnsupportedOperationException();
    }

    public FSGlyphVector getGlyphVector(OutputDevice outputDevice, FSFont font, String string) {
        throw new UnsupportedOperationException();
    }

    public void drawGlyphVector(OutputDevice outputDevice, FSGlyphVector vector, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void setup(FontContext context) {
    }

    static class ReplacementChar {
        char replacement;
        PdfBoxFontResolver.FontDescription fontDescription;
        float width;

        ReplacementChar() {
        }
    }
}

