/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilderState;
import com.openhtmltopdf.util.XRLog;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfRendererBuilder
extends BaseRendererBuilder<PdfRendererBuilder, PdfRendererBuilderState> {
    public PdfRendererBuilder() {
        super((BaseRendererBuilder.BaseRendererBuilderState)new PdfRendererBuilderState());
    }

    public void run() throws Exception {
        PdfBoxRenderer renderer = null;
        try {
            renderer = this.buildPdfRenderer();
            renderer.layout();
            renderer.createPDF();
        }
        finally {
            if (renderer != null) {
                renderer.close();
            }
        }
    }

    public PdfBoxRenderer buildPdfRenderer() {
        UnicodeImplementation unicode = new UnicodeImplementation(((PdfRendererBuilderState)this.state)._reorderer, ((PdfRendererBuilderState)this.state)._splitter, ((PdfRendererBuilderState)this.state)._lineBreaker, ((PdfRendererBuilderState)this.state)._unicodeToLowerTransformer, ((PdfRendererBuilderState)this.state)._unicodeToUpperTransformer, ((PdfRendererBuilderState)this.state)._unicodeToTitleTransformer, ((PdfRendererBuilderState)this.state)._textDirection, ((PdfRendererBuilderState)this.state)._charBreaker);
        PageDimensions pageSize = new PageDimensions(((PdfRendererBuilderState)this.state)._pageWidth, ((PdfRendererBuilderState)this.state)._pageHeight, ((PdfRendererBuilderState)this.state)._isPageSizeInches);
        BaseDocument doc = new BaseDocument(((PdfRendererBuilderState)this.state)._baseUri, ((PdfRendererBuilderState)this.state)._html, ((PdfRendererBuilderState)this.state)._document, ((PdfRendererBuilderState)this.state)._file, ((PdfRendererBuilderState)this.state)._uri);
        PdfBoxRenderer renderer = new PdfBoxRenderer(doc, unicode, pageSize, (PdfRendererBuilderState)this.state);
        PdfBoxFontResolver resolver = renderer.getFontResolver();
        for (AddedFont font : ((PdfRendererBuilderState)this.state)._fonts) {
            IdentValue fontStyle = null;
            if (font.style == BaseRendererBuilder.FontStyle.NORMAL) {
                fontStyle = IdentValue.NORMAL;
            } else if (font.style == BaseRendererBuilder.FontStyle.ITALIC) {
                fontStyle = IdentValue.ITALIC;
            } else if (font.style == BaseRendererBuilder.FontStyle.OBLIQUE) {
                fontStyle = IdentValue.OBLIQUE;
            }
            if (font.supplier != null) {
                resolver.addFont((FSSupplier<InputStream>)font.supplier, font.family, font.weight, fontStyle, font.subset);
                continue;
            }
            try {
                resolver.addFont(font.fontFile, font.family, font.weight, fontStyle, font.subset);
            }
            catch (Exception e) {
                XRLog.init((Level)Level.WARNING, (String)("Font " + font.fontFile + " could not be loaded"), (Throwable)e);
            }
        }
        return renderer;
    }

    public PdfRendererBuilder toStream(OutputStream out) {
        ((PdfRendererBuilderState)this.state)._os = out;
        return this;
    }

    public PdfRendererBuilder usePdfVersion(float version) {
        ((PdfRendererBuilderState)this.state)._pdfVersion = version;
        return this;
    }

    public PdfRendererBuilder usePDDocument(PDDocument doc) {
        ((PdfRendererBuilderState)this.state).pddocument = doc;
        return this;
    }

    public PdfRendererBuilder useFont(FSSupplier<InputStream> supplier, String fontFamily, Integer fontWeight, BaseRendererBuilder.FontStyle fontStyle, boolean subset) {
        ((PdfRendererBuilderState)this.state)._fonts.add(new AddedFont(supplier, null, fontWeight, fontFamily, subset, fontStyle));
        return this;
    }

    public PdfRendererBuilder useFont(FSSupplier<InputStream> supplier, String fontFamily) {
        return this.useFont(supplier, fontFamily, (Integer)400, BaseRendererBuilder.FontStyle.NORMAL, true);
    }

    public PdfRendererBuilder useFont(File fontFile, String fontFamily, Integer fontWeight, BaseRendererBuilder.FontStyle fontStyle, boolean subset) {
        ((PdfRendererBuilderState)this.state)._fonts.add(new AddedFont(null, fontFile, fontWeight, fontFamily, subset, fontStyle));
        return this;
    }

    public PdfRendererBuilder useFont(File fontFile, String fontFamily) {
        return this.useFont(fontFile, fontFamily, (Integer)400, BaseRendererBuilder.FontStyle.NORMAL, true);
    }

    public PdfRendererBuilder withProducer(String producer) {
        ((PdfRendererBuilderState)this.state)._producer = producer;
        return this;
    }

    static class AddedFont {
        private final FSSupplier<InputStream> supplier;
        private final File fontFile;
        private final Integer weight;
        private final String family;
        private final boolean subset;
        private final BaseRendererBuilder.FontStyle style;

        private AddedFont(FSSupplier<InputStream> supplier, File fontFile, Integer weight, String family, boolean subset, BaseRendererBuilder.FontStyle style) {
            this.supplier = supplier;
            this.fontFile = fontFile;
            this.weight = weight;
            this.family = family;
            this.subset = subset;
            this.style = style;
        }
    }
}

