/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.pdfboxout.BookmarkElement;
import com.openhtmltopdf.pdfboxout.PdfBoxImageElement;
import com.openhtmltopdf.pdfboxout.PdfBoxObjectDrawerReplacedElement;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxSVGReplacedElement;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import org.w3c.dom.Element;

public class PdfBoxReplacedElementFactory
implements ReplacedElementFactory {
    private final PdfBoxOutputDevice _outputDevice;
    private final SVGDrawer _svgImpl;
    private final SVGDrawer _mathmlImpl;
    private final FSObjectDrawerFactory _objectDrawerFactory;

    public PdfBoxReplacedElementFactory(PdfBoxOutputDevice outputDevice, SVGDrawer svgImpl, FSObjectDrawerFactory objectDrawerFactory, SVGDrawer mathmlImpl) {
        this._outputDevice = outputDevice;
        this._svgImpl = svgImpl;
        this._objectDrawerFactory = objectDrawerFactory;
        this._mathmlImpl = mathmlImpl;
    }

    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("math") && this._mathmlImpl != null) {
            return new PdfBoxSVGReplacedElement(e, this._mathmlImpl, cssWidth, cssHeight, (Box)box, (CssContext)c, c.getSharedContext());
        }
        if (nodeName.equals("svg") && this._svgImpl != null) {
            return new PdfBoxSVGReplacedElement(e, this._svgImpl, cssWidth, cssHeight, (Box)box, (CssContext)c, c.getSharedContext());
        }
        if (nodeName.equals("img")) {
            FSImage fsImage;
            String srcAttr = e.getAttribute("src");
            if (srcAttr != null && srcAttr.length() > 0 && (fsImage = uac.getImageResource(srcAttr).getImage()) != null) {
                boolean hasMaxProperty;
                boolean hasMaxHeight = !box.getStyle().isMaxHeightNone();
                boolean hasMaxWidth = !box.getStyle().isMaxWidthNone();
                boolean bl = hasMaxProperty = hasMaxWidth || hasMaxHeight;
                if (cssWidth == -1 && cssHeight == -1) {
                    if (hasMaxProperty) {
                        long maxWidth = CalculatedStyle.getCSSMaxWidth((CssContext)c, (Box)box);
                        long maxHeight = CalculatedStyle.getCSSMaxHeight((CssContext)c, (Box)box);
                        int intrinsicHeight = fsImage.getHeight();
                        int intrinsicWidth = fsImage.getWidth();
                        if (hasMaxWidth && hasMaxHeight) {
                            double rw = (double)intrinsicWidth / (double)maxWidth;
                            double rh = (double)intrinsicHeight / (double)maxHeight;
                            if (rw > rh) {
                                fsImage.scale((int)maxWidth, -1);
                            } else {
                                fsImage.scale(-1, (int)maxHeight);
                            }
                        } else if (hasMaxWidth && (long)intrinsicWidth > maxWidth) {
                            fsImage.scale((int)maxWidth, -1);
                        } else if (hasMaxHeight && (long)intrinsicHeight > maxHeight) {
                            fsImage.scale(-1, (int)maxHeight);
                        }
                    }
                } else if (hasMaxProperty) {
                    long maxWidth = box.getStyle().asLength((CssContext)c, CSSName.MAX_WIDTH).value();
                    long maxHeight = box.getStyle().asLength((CssContext)c, CSSName.MAX_HEIGHT).value();
                    if ((long)cssHeight > maxHeight && cssHeight >= cssWidth) {
                        fsImage.scale(-1, (int)maxHeight);
                    } else if ((long)cssWidth > maxWidth) {
                        fsImage.scale((int)maxWidth, -1);
                    } else {
                        fsImage.scale(cssWidth, cssHeight);
                    }
                } else {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new PdfBoxImageElement(e, fsImage, c.getSharedContext());
            }
        } else if (!nodeName.equals("input")) {
            FSObjectDrawer drawer;
            if (nodeName.equals("bookmark")) {
                BookmarkElement result = new BookmarkElement();
                if (e.hasAttribute("name")) {
                    String name = e.getAttribute("name");
                    c.addBoxId(name, (Box)box);
                    result.setAnchorName(name);
                }
                return result;
            }
            if (nodeName.equals("object") && this._objectDrawerFactory != null && (drawer = this._objectDrawerFactory.createDrawer(e)) != null) {
                return new PdfBoxObjectDrawerReplacedElement(e, drawer, cssWidth, cssHeight, c.getSharedContext());
            }
        }
        return null;
    }

    public void reset() {
    }

    public void remove(Element e) {
    }
}

