/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.objects.pdf;

import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Shape;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Charsets;
import org.w3c.dom.Element;

public class MergeBackgroundPdfDrawer
implements FSObjectDrawer {
    private final Map<PDFBoxDeviceReference, SoftReference<Map<String, PDFormXObject>>> formMap = new HashMap<PDFBoxDeviceReference, SoftReference<Map<String, PDFormXObject>>>();

    public Map<Shape, String> drawObject(Element e, double x, double y, double width, double height, OutputDevice outputDevice, RenderingContext ctx, int dotsPerPixel) {
        if (!(outputDevice instanceof PdfBoxOutputDevice)) {
            return null;
        }
        String pdfsrc = e.getAttribute("pdfsrc");
        String pdfpageValue = e.getAttribute("pdfpage");
        if (pdfpageValue == null || pdfpageValue.isEmpty()) {
            pdfpageValue = "1";
        }
        int pdfpage = Integer.parseInt(pdfpageValue);
        PdfBoxOutputDevice pdfBoxOutputDevice = (PdfBoxOutputDevice)outputDevice;
        String url = ctx.getUac().resolveURI(pdfsrc);
        SoftReference<Map<String, PDFormXObject>> mapWeakReference = this.formMap.get(new PDFBoxDeviceReference(pdfBoxOutputDevice));
        Map<String, PDFormXObject> map = null;
        if (mapWeakReference != null) {
            map = mapWeakReference.get();
        }
        if (map == null) {
            map = new HashMap<String, PDFormXObject>();
            this.formMap.put(new PDFBoxDeviceReference(pdfBoxOutputDevice), new SoftReference<Map<String, PDFormXObject>>(map));
        }
        try {
            PDFormXObject pdFormXObject = map.get(url);
            LayerUtility layerUtility = new LayerUtility(pdfBoxOutputDevice.getWriter());
            if (pdFormXObject == null) {
                try (InputStream inputStream = new URL(url).openStream();){
                    PDFParser pdfParser = new PDFParser((RandomAccessRead)new RandomAccessBuffer(inputStream));
                    pdfParser.parse();
                    pdFormXObject = layerUtility.importPageAsForm(pdfParser.getPDDocument(), pdfpage - 1);
                    pdfParser.getPDDocument().close();
                }
                map.put(url, pdFormXObject);
            }
            PDPage page = pdfBoxOutputDevice.getPage();
            layerUtility.wrapInSaveRestore(page);
            COSArray cosArray = (COSArray)page.getCOSObject().getDictionaryObject(COSName.CONTENTS);
            COSStream saveStateAndPlacePageBackgroundStream = (COSStream)cosArray.get(0);
            OutputStream saveAndPlaceStream = saveStateAndPlacePageBackgroundStream.createOutputStream();
            saveAndPlaceStream.write("q\n".getBytes(Charsets.US_ASCII));
            COSName name = page.getResources().add(pdFormXObject);
            name.writePDF(saveAndPlaceStream);
            saveAndPlaceStream.write(32);
            saveAndPlaceStream.write("Do\n".getBytes(Charsets.US_ASCII));
            saveAndPlaceStream.write("Q\n".getBytes(Charsets.US_ASCII));
            saveAndPlaceStream.write("q\n".getBytes(Charsets.US_ASCII));
            saveAndPlaceStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    private static class PDFBoxDeviceReference
    extends WeakReference<PdfBoxOutputDevice> {
        PDFBoxDeviceReference(PdfBoxOutputDevice referent) {
            super(referent);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PDFBoxDeviceReference) {
                return ((PDFBoxDeviceReference)obj).get() == this.get();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            PdfBoxOutputDevice pdfBoxOutputDevice = (PdfBoxOutputDevice)this.get();
            if (pdfBoxOutputDevice != null) {
                return pdfBoxOutputDevice.hashCode();
            }
            return 0;
        }
    }
}

