/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.layout.CollapsedBorderSide;
import com.openhtmltopdf.layout.InlinePaintable;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.DisplayListItem;
import com.openhtmltopdf.render.OperatorClip;
import com.openhtmltopdf.render.OperatorSetClip;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.DisplayListCollector;
import com.openhtmltopdf.render.displaylist.DisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListOperation;
import com.openhtmltopdf.render.displaylist.PaintBackgroundAndBorders;
import com.openhtmltopdf.render.displaylist.PaintFixedLayer;
import com.openhtmltopdf.render.displaylist.PaintInlineContent;
import com.openhtmltopdf.render.displaylist.PaintLayerBackgroundAndBorder;
import com.openhtmltopdf.render.displaylist.PaintListMarkers;
import com.openhtmltopdf.render.displaylist.PaintPopClipLayer;
import com.openhtmltopdf.render.displaylist.PaintPopClipRect;
import com.openhtmltopdf.render.displaylist.PaintPopTransformLayer;
import com.openhtmltopdf.render.displaylist.PaintPushClipLayer;
import com.openhtmltopdf.render.displaylist.PaintPushClipRect;
import com.openhtmltopdf.render.displaylist.PaintPushTransformLayer;
import com.openhtmltopdf.render.displaylist.PaintReplacedElement;
import com.openhtmltopdf.render.displaylist.PaintReplacedElements;
import com.openhtmltopdf.render.displaylist.PaintRootElementBackground;
import com.openhtmltopdf.render.displaylist.TransformCreator;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class DisplayListPainter {
    private void clip(RenderingContext c, OperatorClip clip) {
        c.getOutputDevice().pushClip(clip.getClip());
    }

    private void setClip(RenderingContext c, OperatorSetClip setclip) {
        c.getOutputDevice().popClip();
    }

    private void updateTableHeaderFooterPosition(RenderingContext c, BlockBox container) {
        TableBox table;
        if (container.getStyle().isTable() && (table = (TableBox)container).hasContentLimitContainer()) {
            table.updateHeaderFooterPosition(c);
        }
    }

    private void paintBackgroundAndBorders(RenderingContext c, List<DisplayListItem> blocks, Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders) {
        for (DisplayListItem dli : blocks) {
            List<CollapsedBorderSide> borders;
            TableCellBox cell;
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            BlockBox box = (BlockBox)dli;
            this.updateTableHeaderFooterPosition(c, box);
            box.paintBackground(c);
            box.paintBorder(c);
            if (collapsedTableBorders == null || !(box instanceof TableCellBox) || !(cell = (TableCellBox)box).hasCollapsedPaintingBorder() || (borders = collapsedTableBorders.get(cell)) == null) continue;
            for (CollapsedBorderSide border : borders) {
                border.getCell().paintCollapsedBorder(c, border.getSide());
            }
        }
    }

    private void paintListMarkers(RenderingContext c, List<DisplayListItem> blocks) {
        for (DisplayListItem dli : blocks) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            ((BlockBox)dli).paintListMarker(c);
        }
    }

    private void paintInlineContent(RenderingContext c, List<DisplayListItem> inlines) {
        for (DisplayListItem dli : inlines) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            if (dli instanceof BlockBox) {
                BlockBox bb = (BlockBox)dli;
                List<PageBox> pageBoxes = bb.getContainingLayer().getPages();
                DisplayListCollector dlCollector = new DisplayListCollector(pageBoxes);
                DisplayListContainer.DisplayListPageContainer pageInstructions = dlCollector.collectInlineBlock(c, bb, EnumSet.noneOf(DisplayListCollector.CollectFlags.class));
                this.paint(c, pageInstructions);
                continue;
            }
            InlinePaintable paintable = (InlinePaintable)((Object)dli);
            paintable.paintInline(c);
        }
    }

    private void paintReplacedElements(RenderingContext c, List<DisplayListItem> replaceds) {
        for (DisplayListItem dli : replaceds) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            BlockBox box = (BlockBox)dli;
            this.paintReplacedElement(c, box);
        }
    }

    private void paintReplacedElement(RenderingContext c, BlockBox replaced) {
        Rectangle contentBounds = replaced.getContentAreaEdge(replaced.getAbsX(), replaced.getAbsY(), c);
        Point loc = replaced.getReplacedElement().getLocation();
        if (contentBounds.x != loc.x || contentBounds.y != loc.y) {
            replaced.getReplacedElement().setLocation(contentBounds.x, contentBounds.y);
        }
        c.getOutputDevice().paintReplacedElement(c, replaced);
    }

    private void pushTransform(RenderingContext c, Box master) {
        AffineTransform transform = TransformCreator.createPageCoordinatesTranform(c, master, c.getPage());
        c.getOutputDevice().pushTransformLayer(transform);
    }

    private void popTransform(RenderingContext c, Box master) {
        c.getOutputDevice().popTransformLayer();
    }

    private void pushClips(RenderingContext c, PaintPushClipLayer clips) {
        for (Box clipBox : clips.getClipBoxes()) {
            Rectangle clip = clipBox.getBorderBox(c);
            c.getOutputDevice().pushClip(clip);
        }
    }

    private void pushClipRect(RenderingContext c, Rectangle clip) {
        c.getOutputDevice().pushClip(clip);
    }

    private void popClipRect(RenderingContext c) {
        c.getOutputDevice().popClip();
    }

    private void popClips(RenderingContext c, PaintPopClipLayer clips) {
        for (int i = 0; i < clips.getClipBoxes().size(); ++i) {
            c.getOutputDevice().popClip();
        }
    }

    private void paintFixed(RenderingContext c, Layer layer) {
        layer.positionFixedLayer(c);
        List<PageBox> pages = layer.getPages();
        DisplayListCollector collector = new DisplayListCollector(pages);
        DisplayListContainer dlPages = collector.collectFixed(c, layer);
        this.paint(c, dlPages.getPageInstructions(c.getPageNo()));
    }

    public void paint(RenderingContext c, DisplayListContainer.DisplayListPageContainer pageOperations) {
        for (DisplayListOperation op : pageOperations.getOperations()) {
            DisplayListOperation dlo;
            if (op instanceof PaintRootElementBackground) {
                dlo = (PaintRootElementBackground)op;
                ((PaintRootElementBackground)dlo).getRoot().paintRootElementBackground(c);
                continue;
            }
            if (op instanceof PaintLayerBackgroundAndBorder) {
                dlo = (PaintLayerBackgroundAndBorder)op;
                ((PaintLayerBackgroundAndBorder)dlo).getMaster().paintBackground(c);
                ((PaintLayerBackgroundAndBorder)dlo).getMaster().paintBorder(c);
                continue;
            }
            if (op instanceof PaintReplacedElement) {
                dlo = (PaintReplacedElement)op;
                this.paintReplacedElement(c, ((PaintReplacedElement)dlo).getMaster());
                continue;
            }
            if (op instanceof PaintBackgroundAndBorders) {
                dlo = (PaintBackgroundAndBorders)op;
                this.paintBackgroundAndBorders(c, ((PaintBackgroundAndBorders)dlo).getBlocks(), ((PaintBackgroundAndBorders)dlo).getCollapedTableBorders());
                continue;
            }
            if (op instanceof PaintListMarkers) {
                dlo = (PaintListMarkers)op;
                this.paintListMarkers(c, ((PaintListMarkers)dlo).getBlocks());
                continue;
            }
            if (op instanceof PaintInlineContent) {
                dlo = (PaintInlineContent)op;
                this.paintInlineContent(c, ((PaintInlineContent)dlo).getInlines());
                continue;
            }
            if (op instanceof PaintReplacedElements) {
                dlo = (PaintReplacedElements)op;
                this.paintReplacedElements(c, ((PaintReplacedElements)dlo).getReplaceds());
                continue;
            }
            if (op instanceof PaintPushTransformLayer) {
                dlo = (PaintPushTransformLayer)op;
                this.pushTransform(c, ((PaintPushTransformLayer)dlo).getMaster());
                continue;
            }
            if (op instanceof PaintPopTransformLayer) {
                dlo = (PaintPopTransformLayer)op;
                this.popTransform(c, ((PaintPopTransformLayer)dlo).getMaster());
                continue;
            }
            if (op instanceof PaintPushClipLayer) {
                dlo = (PaintPushClipLayer)op;
                this.pushClips(c, (PaintPushClipLayer)dlo);
                continue;
            }
            if (op instanceof PaintPopClipLayer) {
                dlo = (PaintPopClipLayer)op;
                this.popClips(c, (PaintPopClipLayer)dlo);
                continue;
            }
            if (op instanceof PaintFixedLayer) {
                dlo = (PaintFixedLayer)op;
                this.paintFixed(c, ((PaintFixedLayer)dlo).getLayer());
                continue;
            }
            if (op instanceof PaintPushClipRect) {
                dlo = (PaintPushClipRect)op;
                this.pushClipRect(c, ((PaintPushClipRect)dlo).getClipBox());
                continue;
            }
            if (!(op instanceof PaintPopClipRect)) continue;
            this.popClipRect(c);
        }
    }
}

