/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils.statetracking;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.testutils.statetracking.DirectionalGraph;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class StateMachineTrackerUtil {
    private DirectionalGraph graph;
    private int[] states;
    private volatile boolean isRecording;
    private LinkedList allMoves;
    private LinkedList illegalMoves;
    private int currentState;
    private int destinationState;
    private boolean isWaitingForDestination;
    private boolean stateUnknown;
    private Logable log;

    public StateMachineTrackerUtil(int[] nArray, Logable logable) {
        this.log = logable;
        this.states = new int[nArray.length];
        System.arraycopy(nArray, 0, this.states, 0, nArray.length);
        Arrays.sort(this.states);
        this.graph = new DirectionalGraph(this.states);
        this.illegalMoves = new LinkedList();
        this.allMoves = new LinkedList();
        this.isWaitingForDestination = false;
        this.stateUnknown = true;
    }

    public void addTransition(int n, int n2) {
        this.graph.addEdge(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftState(int n) {
        LinkedList linkedList = this.allMoves;
        synchronized (linkedList) {
            if (this.isRecording) {
                Transition transition = new Transition(this.currentState, n, this.stateUnknown);
                this.allMoves.addLast(transition);
                if (!this.stateUnknown) {
                    boolean bl = this.graph.isEdge(this.currentState, n);
                    if (!bl) {
                        this.illegalMoves.addLast(transition);
                    }
                    this.log.finer("StateMachineTrackerUtil: transition valid=" + bl);
                }
            }
            this.currentState = n;
            this.stateUnknown = false;
            if (this.isWaitingForDestination && this.currentState == this.destinationState) {
                this.isWaitingForDestination = false;
            }
            this.allMoves.notifyAll();
            this.log.finer("StateMachineTrackerUtil: Shifted state to " + this.currentState + ". isWaitingForDestination=" + this.isWaitingForDestination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateUnknown() {
        LinkedList linkedList = this.allMoves;
        synchronized (linkedList) {
            this.stateUnknown = true;
        }
    }

    public void startRecording() {
        this.isRecording = true;
    }

    public void stopRecording() {
        this.isRecording = false;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestination(int n) {
        LinkedList linkedList = this.allMoves;
        synchronized (linkedList) {
            this.destinationState = n;
            boolean bl = this.isWaitingForDestination = this.currentState != n;
            if (this.isWaitingForDestination) {
                this.log.finer("started waiting for destination state: " + n + ". current state:" + this.currentState);
            } else {
                this.log.finer("set destination to current state: " + this.currentState + " (not waiting)");
            }
        }
    }

    public void waitForDestination() throws OperationTimedOutException {
        this.waitForDestination(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForDestination(int n) throws OperationTimedOutException {
        long l = 0L;
        if (n > 0) {
            l = System.currentTimeMillis() + (long)n;
        }
        LinkedList linkedList = this.allMoves;
        synchronized (linkedList) {
            while (true) {
                if (!this.isWaitingForDestination) {
                    this.log.finer("StateMachineTrackerUtil: destination reached (or not set)");
                    return;
                }
                this.log.finest("StateMachineTrackerUtil: still waiting for destination");
                try {
                    if (n > 0) {
                        long l2 = System.currentTimeMillis();
                        if (l2 >= l) {
                            throw new OperationTimedOutException("Timed out waiting for destination state.");
                        }
                        this.allMoves.wait(l - l2);
                        continue;
                    }
                    this.allMoves.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getTransitions() {
        LinkedList linkedList = this.allMoves;
        synchronized (linkedList) {
            Vector vector = new Vector(this.allMoves);
            return vector.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getIllegalTransitions() {
        LinkedList linkedList = this.allMoves;
        synchronized (linkedList) {
            Vector vector = new Vector(this.illegalMoves);
            return vector.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTransitions() {
        LinkedList linkedList = this.allMoves;
        synchronized (linkedList) {
            this.allMoves.clear();
            this.illegalMoves.clear();
        }
    }

    public static class Transition {
        private int from;
        private int to;
        private boolean previousStateUnknown;

        public Transition(int n, int n2, boolean bl) {
            this.from = n;
            this.to = n2;
            this.previousStateUnknown = bl;
        }

        public int getFromState() {
            return this.from;
        }

        public int getToState() {
            return this.to;
        }

        public boolean isPreviousStateUnknown() {
            return this.previousStateUnknown;
        }
    }
}

