/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.TCKSbbMessageFilter;
import java.rmi.RemoteException;
import java.util.LinkedList;

public class QueuingResourceListener
extends BaseTCKResourceListener {
    private final SleeTCKTestUtils utils;
    private final LinkedList queue = new LinkedList();

    public QueuingResourceListener(SleeTCKTestUtils sleeTCKTestUtils) {
        this.utils = sleeTCKTestUtils;
    }

    public TCKSbbMessage nextMessage() throws TCKTestErrorException, TCKTestFailureException {
        return this.nextMessage(null);
    }

    public synchronized TCKSbbMessage nextMessage(TCKSbbMessageFilter tCKSbbMessageFilter) throws TCKTestErrorException, TCKTestFailureException {
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.utils.getTestTimeout();
        while (l < l2) {
            while (this.queue.isEmpty() && l < l2) {
                try {
                    this.wait(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = System.currentTimeMillis();
            }
            while (!this.queue.isEmpty()) {
                Object e = this.queue.removeFirst();
                if (e instanceof Exception) {
                    if (e instanceof TCKTestFailureException) {
                        throw (TCKTestFailureException)e;
                    }
                    if (e instanceof TCKTestErrorException) {
                        throw (TCKTestErrorException)e;
                    }
                    throw new TCKTestErrorException("Exception received from resource or Sbb", (Exception)e);
                }
                TCKSbbMessage tCKSbbMessage = (TCKSbbMessage)e;
                if (tCKSbbMessageFilter != null && !tCKSbbMessageFilter.accept(tCKSbbMessage)) continue;
                return tCKSbbMessage;
            }
        }
        throw new OperationTimedOutException("Timed out waiting for a message or Exception");
    }

    public synchronized void onSbbMessage(TCKSbbMessage tCKSbbMessage, TCKActivityID tCKActivityID) throws RemoteException {
        this.utils.getLog().info("Received message from SBB");
        this.queue.addLast(tCKSbbMessage);
        this.notify();
    }

    public synchronized void onException(Exception exception) throws RemoteException {
        this.utils.getLog().info("Received Exception from SBB or resource.");
        this.queue.addLast(exception);
        this.notify();
    }
}

