/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.sets;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanLookup;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;

public class Test2253and2254Test
extends GenericUsageTest {
    private static final int TEST_ID_FOR_UNNAMED = 2253;
    private static final int TEST_ID_FOR_NAMED = 2254;
    private static final String NAMED_SET_NAME = "NamedParameterSet";
    private GenericUsageMBeanLookup mBeanLookup;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListenerUnnamed;
    private QueuingNotificationListener notificationListenerNamed;

    public TCKTestResult run() throws Exception {
        int i;
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("token activity");
        GenericUsageSbbInstructions instructionsForUnnamed = new GenericUsageSbbInstructions(null);
        instructionsForUnnamed.addFirstCountIncrement(1L);
        instructionsForUnnamed.addTimeBetweenNewConnectionsSamples(2L);
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructionsForUnnamed.toExported(), activityID, null);
        GenericUsageSbbInstructions instructionsForNamed = new GenericUsageSbbInstructions(NAMED_SET_NAME);
        instructionsForNamed.addFirstCountIncrement(4L);
        instructionsForNamed.addTimeBetweenNewConnectionsSamples(5L);
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructionsForNamed.toExported(), activityID, null);
        this.getLog().info("waiting for replies");
        this.resourceListener.nextMessage();
        this.resourceListener.nextMessage();
        this.getLog().info("received replies");
        this.getLog().info("waiting for usage notifications");
        for (i = 0; i < instructionsForUnnamed.getTotalUpdates(); ++i) {
            this.notificationListenerUnnamed.nextNotification();
        }
        for (i = 0; i < instructionsForNamed.getTotalUpdates(); ++i) {
            this.notificationListenerNamed.nextNotification();
        }
        this.getLog().info("received all " + (instructionsForUnnamed.getTotalUpdates() + instructionsForNamed.getTotalUpdates()) + " usage notifications");
        this.getLog().info("checking that parameter updates to both sets were independent");
        long firstCountForUnnamed = this.mBeanLookup.getUnnamedGenericUsageMBeanProxy().getFirstCount(false);
        long firstCountForNamed = this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(NAMED_SET_NAME).getFirstCount(false);
        double timeBetweenNewConnectionsCountForUnnamed = this.mBeanLookup.getUnnamedGenericUsageMBeanProxy().getTimeBetweenNewConnections(false).getSampleCount();
        double timeBetweenNewConnectionsCountForNamed = this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(NAMED_SET_NAME).getTimeBetweenNewConnections(false).getSampleCount();
        String expectedValues = "firstCountForUnnamed=1,firstCountForNamed=4timeBetweenNewConnectionsCountForUnnamed=1timeBetweenNewConnectionsCountForNamed=1";
        String actualValues = "firstCountForUnnamed=" + firstCountForUnnamed + ",firstCountForNamed=" + firstCountForNamed + "timeBetweenNewConnectionsCountForUnnamed=" + timeBetweenNewConnectionsCountForUnnamed + "timeBetweenNewConnectionsCountForNamed=" + timeBetweenNewConnectionsCountForNamed;
        if (firstCountForNamed == 0L) {
            return TCKTestResult.failed(2254, "Updates to the firstCount parameter in a named parameter set were not applied.");
        }
        if (firstCountForNamed == 5L) {
            return TCKTestResult.failed(2253, "Updates to firstCount usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (firstCountForUnnamed == 0L) {
            return TCKTestResult.failed(2253, "Updates to the firstCount parameter in the unnamed parameter set were not applied.");
        }
        if (firstCountForUnnamed == 5L) {
            return TCKTestResult.failed(2254, "Updates to firstCount usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (timeBetweenNewConnectionsCountForNamed == 0.0) {
            return TCKTestResult.failed(2254, "Updates to the timeBetweenNewConnections parameter in a named parameter set were not applied.");
        }
        if (timeBetweenNewConnectionsCountForNamed == 2.0) {
            return TCKTestResult.failed(2253, "Updates to timeBetweenNewConnections usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (timeBetweenNewConnectionsCountForUnnamed == 0.0) {
            return TCKTestResult.failed(2253, "Updates to the timeBetweenNewConnections parameter in the unnamed parameter set were not applied.");
        }
        if (timeBetweenNewConnectionsCountForUnnamed == 2.0) {
            return TCKTestResult.failed(2254, "Updates to timeBetweenNewConnections usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (firstCountForUnnamed != 1L || timeBetweenNewConnectionsCountForUnnamed != 1.0) {
            return TCKTestResult.failed(2253, "Usage parameter values were not set as expected. Expected values: " + expectedValues + ", actual values: " + actualValues);
        }
        if (firstCountForNamed != 4L || timeBetweenNewConnectionsCountForNamed != 1.0) {
            return TCKTestResult.failed(2254, "Usage parameter values were not set as expected. Expected values: " + expectedValues + ", actual values: " + actualValues);
        }
        this.getLog().info("parameter checks ok");
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.mBeanLookup = this.getGenericUsageMBeanLookup();
        this.mBeanLookup.getServiceUsageMBeanProxy().createUsageParameterSet(this.mBeanLookup.getSbbID(), NAMED_SET_NAME);
        this.notificationListenerUnnamed = new QueuingNotificationListener(this.utils());
        this.notificationListenerNamed = new QueuingNotificationListener(this.utils());
        this.mBeanLookup.getUnnamedGenericUsageMBeanProxy().addNotificationListener(this.notificationListenerUnnamed, null, null);
        this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(NAMED_SET_NAME).addNotificationListener(this.notificationListenerNamed, null, null);
    }

    public void tearDown() throws Exception {
        if (this.mBeanLookup != null) {
            if (this.notificationListenerUnnamed != null) {
                this.mBeanLookup.getUnnamedGenericUsageMBeanProxy().removeNotificationListener(this.notificationListenerUnnamed);
            }
            if (this.notificationListenerNamed != null) {
                this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(NAMED_SET_NAME).removeNotificationListener(this.notificationListenerNamed);
            }
        }
        super.tearDown();
    }
}

