/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.sets;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanLookup;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;

public class Test2239Test
extends GenericUsageTest {
    private static final int TEST_ID = 2239;
    private static final String FOO_SET_NAME = "FooSet";
    private static final String BAR_SET_NAME = "BarSet";
    private GenericUsageMBeanLookup mBeanLookup;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListenerFoo;
    private QueuingNotificationListener notificationListenerBar;

    public TCKTestResult run() throws Exception {
        int i;
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("token activity");
        GenericUsageSbbInstructions instructionsForFoo = new GenericUsageSbbInstructions(FOO_SET_NAME);
        instructionsForFoo.addFirstCountIncrement(1L);
        instructionsForFoo.addTimeBetweenNewConnectionsSamples(2L);
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructionsForFoo.toExported(), activityID, null);
        GenericUsageSbbInstructions instructionsForBar = new GenericUsageSbbInstructions(BAR_SET_NAME);
        instructionsForBar.addFirstCountIncrement(4L);
        instructionsForBar.addTimeBetweenNewConnectionsSamples(5L);
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructionsForBar.toExported(), activityID, null);
        this.getLog().info("waiting for replies");
        this.resourceListener.nextMessage();
        this.resourceListener.nextMessage();
        this.getLog().info("received replies");
        this.getLog().info("waiting for usage notifications");
        for (i = 0; i < instructionsForFoo.getTotalUpdates(); ++i) {
            this.notificationListenerFoo.nextNotification();
        }
        for (i = 0; i < instructionsForBar.getTotalUpdates(); ++i) {
            this.notificationListenerBar.nextNotification();
        }
        this.getLog().info("received all " + (instructionsForFoo.getTotalUpdates() + instructionsForBar.getTotalUpdates()) + " usage notifications");
        this.getLog().info("checking that parameter updates to both sets were independent");
        long firstCountForFoo = this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(FOO_SET_NAME).getFirstCount(false);
        long firstCountForBar = this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(BAR_SET_NAME).getFirstCount(false);
        double timeBetweenNewConnectionsMeanForFoo = this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(FOO_SET_NAME).getTimeBetweenNewConnections(false).getMean();
        double timeBetweenNewConnectionsMeanForBar = this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(BAR_SET_NAME).getTimeBetweenNewConnections(false).getMean();
        String expectedValues = "firstCountForFoo=1,firstCountForBar=4timeBetweenNewConnectionsMeanForFoo=2timeBetweenNewConnectionsMeanForBar=5";
        String actualValues = "firstCountForFoo=" + firstCountForFoo + ",firstCountForBar=" + firstCountForBar + "timeBetweenNewConnectionsMeanForFoo=" + timeBetweenNewConnectionsMeanForFoo + "timeBetweenNewConnectionsMeanForBar=" + timeBetweenNewConnectionsMeanForBar;
        if (firstCountForFoo == 5L) {
            return TCKTestResult.failed(2239, "Updates to firstCount usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (firstCountForBar == 5L) {
            return TCKTestResult.failed(2239, "Updates to firstCount usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (timeBetweenNewConnectionsMeanForFoo == 3.5) {
            return TCKTestResult.failed(2239, "Updates to timeBetweenNewConnections usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (timeBetweenNewConnectionsMeanForBar == 3.5) {
            return TCKTestResult.failed(2239, "Updates to timeBetweenNewConnections usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (firstCountForFoo != 1L || firstCountForBar != 4L || timeBetweenNewConnectionsMeanForFoo != 2.0 || timeBetweenNewConnectionsMeanForBar != 5.0) {
            return TCKTestResult.failed(2239, "Usage parameter values were not set as expected. Expected values: " + expectedValues + ", actual values: " + actualValues);
        }
        this.getLog().info("parameter checks ok");
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.mBeanLookup = this.getGenericUsageMBeanLookup();
        this.mBeanLookup.getServiceUsageMBeanProxy().createUsageParameterSet(this.mBeanLookup.getSbbID(), FOO_SET_NAME);
        this.mBeanLookup.getServiceUsageMBeanProxy().createUsageParameterSet(this.mBeanLookup.getSbbID(), BAR_SET_NAME);
        this.notificationListenerFoo = new QueuingNotificationListener(this.utils());
        this.notificationListenerBar = new QueuingNotificationListener(this.utils());
        this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(FOO_SET_NAME).addNotificationListener(this.notificationListenerFoo, null, null);
        this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(BAR_SET_NAME).addNotificationListener(this.notificationListenerBar, null, null);
    }

    public void tearDown() throws Exception {
        if (this.mBeanLookup != null) {
            if (this.notificationListenerFoo != null) {
                this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(FOO_SET_NAME).removeNotificationListener(this.notificationListenerFoo);
            }
            if (this.notificationListenerBar != null) {
                this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(BAR_SET_NAME).removeNotificationListener(this.notificationListenerBar);
            }
        }
        super.tearDown();
    }
}

