/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.scope;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanLookup;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;

public class Test2245Test
extends AbstractSleeTCKTest {
    private static final int TEST_ID = 2245;
    private UsageMBeanLookup mBeanLookupServiceA;
    private UsageMBeanLookup mBeanLookupServiceB;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListenerServiceA;
    private QueuingNotificationListener notificationListenerServiceB;

    public TCKTestResult run() throws Exception {
        int i;
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("token activity");
        GenericUsageSbbInstructions sbbInstructionsA = new GenericUsageSbbInstructions(null);
        sbbInstructionsA.addFirstCountIncrement(1L);
        sbbInstructionsA.addTimeBetweenNewConnectionsSamples(2L);
        this.getLog().info("firing event to SBB in service A");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", sbbInstructionsA.toExported(), activityID, null);
        GenericUsageSbbInstructions sbbInstructionsB = new GenericUsageSbbInstructions(null);
        sbbInstructionsB.addFirstCountIncrement(3L);
        sbbInstructionsB.addTimeBetweenNewConnectionsSamples(4L);
        this.getLog().info("firing event to SBB in service B");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", sbbInstructionsB.toExported(), activityID, null);
        this.getLog().info("waiting for replies from both SBBs");
        this.resourceListener.nextMessage();
        this.resourceListener.nextMessage();
        this.getLog().info("received replies");
        this.getLog().info("waiting for 2 usage notifications for each SBB");
        for (i = 0; i < 2; ++i) {
            this.notificationListenerServiceA.nextNotification();
        }
        for (i = 0; i < 2; ++i) {
            this.notificationListenerServiceB.nextNotification();
        }
        this.getLog().info("received all 4 usage notifications");
        this.getLog().info("checking that parameter updates to both SBBs were independent");
        long firstCountForServiceA = this.mBeanLookupServiceA.getUnnamedSbbUsageMBeanProxy().getCounterParameter("firstCount", false);
        long firstCountForServiceB = this.mBeanLookupServiceB.getUnnamedSbbUsageMBeanProxy().getCounterParameter("firstCount", false);
        double timeBetweenNewConnectionsMeanForServiceA = this.mBeanLookupServiceA.getUnnamedSbbUsageMBeanProxy().getSampleParameter("timeBetweenNewConnections", false).getMean();
        double timeBetweenNewConnectionsMeanForServiceB = this.mBeanLookupServiceB.getUnnamedSbbUsageMBeanProxy().getSampleParameter("timeBetweenNewConnections", false).getMean();
        String expectedValues = "firstCountForServiceA=1,firstCountForServiceB=3timeBetweenNewConnectionsMeanForServiceA=2timeBetweenNewConnectionsMeanForServiceB=4";
        String actualValues = "firstCountForServiceA=" + firstCountForServiceA + ",firstCountForServiceB=" + firstCountForServiceB + "timeBetweenNewConnectionsMeanForServiceA=" + timeBetweenNewConnectionsMeanForServiceA + "timeBetweenNewConnectionsMeanForServiceB=" + timeBetweenNewConnectionsMeanForServiceB;
        if (firstCountForServiceA == 4L || firstCountForServiceB == 4L) {
            return TCKTestResult.failed(2245, "Updates to firstCount usage parameter in the unnamed parameter set in the same SBB in different services were combined -- the parameter sets should be independent.");
        }
        if (timeBetweenNewConnectionsMeanForServiceA == 3.0 || timeBetweenNewConnectionsMeanForServiceB == 3.0) {
            return TCKTestResult.failed(2245, "Updates to timeBetweenNewConnections usage parameter in the unnamed parameter set in the same SBB in different services were combined -- the parameter sets should be independent.");
        }
        if (firstCountForServiceA != 1L || firstCountForServiceB != 3L || timeBetweenNewConnectionsMeanForServiceA != 2.0 || timeBetweenNewConnectionsMeanForServiceB != 4.0) {
            return TCKTestResult.failed(2245, "Usage parameter values were not set as expected. Expected values: " + expectedValues + ", actual values: " + actualValues);
        }
        this.getLog().info("parameter checks ok");
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.mBeanLookupServiceA = new UsageMBeanLookup("Test2244ServiceA", "GenericUsageSbb", this.utils());
        this.mBeanLookupServiceB = new UsageMBeanLookup("Test2244ServiceB", "GenericUsageSbb", this.utils());
        this.notificationListenerServiceA = new QueuingNotificationListener(this.utils());
        this.notificationListenerServiceB = new QueuingNotificationListener(this.utils());
        this.mBeanLookupServiceA.getUnnamedSbbUsageMBeanProxy().addNotificationListener(this.notificationListenerServiceA, null, null);
        this.mBeanLookupServiceB.getUnnamedSbbUsageMBeanProxy().addNotificationListener(this.notificationListenerServiceB, null, null);
    }

    public void tearDown() throws Exception {
        if (this.mBeanLookupServiceA != null && this.notificationListenerServiceA != null) {
            this.mBeanLookupServiceA.getUnnamedSbbUsageMBeanProxy().removeNotificationListener(this.notificationListenerServiceA);
        }
        if (this.mBeanLookupServiceB != null && this.notificationListenerServiceB != null) {
            this.mBeanLookupServiceB.getUnnamedSbbUsageMBeanProxy().removeNotificationListener(this.notificationListenerServiceB);
        }
        if (this.mBeanLookupServiceA != null) {
            this.mBeanLookupServiceA.closeAllMBeans();
        }
        if (this.mBeanLookupServiceB != null) {
            this.mBeanLookupServiceB.closeAllMBeans();
        }
        super.tearDown();
    }
}

