/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.misc;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanLookup;
import com.opencloud.sleetck.lib.testutils.SleeStarter;

public class ParameterSetPersistenceTest
extends AbstractSleeTCKTest {
    private static final int TEST_ID = 2288;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        String[] parameterSets;
        String PARAMETER_SET_NAME = "PersistentParameterSet";
        this.getLog().info("Creating a named usage parameter set");
        GenericUsageMBeanLookup mBeanLookup = new GenericUsageMBeanLookup(this.utils());
        try {
            mBeanLookup.getServiceUsageMBeanProxy().createUsageParameterSet(mBeanLookup.getSbbID(), PARAMETER_SET_NAME);
            parameterSets = mBeanLookup.getServiceUsageMBeanProxy().getUsageParameterSets(mBeanLookup.getSbbID());
            if (parameterSets == null || parameterSets.length == 0 || !parameterSets[0].equals(PARAMETER_SET_NAME)) {
                TCKTestResult tCKTestResult = TCKTestResult.error("Named usage parameter set \"" + PARAMETER_SET_NAME + "\" not visible after creation");
                return tCKTestResult;
            }
        }
        finally {
            mBeanLookup.closeAllMBeans();
        }
        this.getLog().info("Restarting the SLEE");
        SleeStarter.restartSlee(this.utils().getSleeManagementMBeanProxy(), this.utils().getDefaultTimeout());
        this.getLog().info("Checking that the parameter set still exists");
        mBeanLookup = new GenericUsageMBeanLookup(this.utils());
        try {
            parameterSets = mBeanLookup.getServiceUsageMBeanProxy().getUsageParameterSets(mBeanLookup.getSbbID());
            if (parameterSets == null || parameterSets.length == 0 || !parameterSets[0].equals(PARAMETER_SET_NAME)) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(2288, "Named usage parameter set \"" + PARAMETER_SET_NAME + "\" did not survive a SLEE restart");
                return tCKTestResult;
            }
        }
        finally {
            mBeanLookup.closeAllMBeans();
        }
        return TCKTestResult.passed();
    }
}

