/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.common;

import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testsuite.usage.common.UniversalUsageMBeanProxy;
import com.opencloud.sleetck.lib.testsuite.usage.common.UniversalUsageMBeanProxyImpl;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedComponentException;
import javax.slee.UnrecognizedSbbException;
import javax.slee.management.ManagementException;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;

public class UsageMBeanLookup {
    private ServiceID serviceID;
    private SbbID sbbID;
    private ObjectName serviceUsageMBeanName;
    private ObjectName unnamedSbbUsageMBeanName;
    private ServiceUsageMBeanProxy serviceUsageMBeanProxy;
    private UniversalUsageMBeanProxy unnamedSbbUsageMBeanProxy;
    private SleeTCKTestUtils testUtils;
    private HashMap namedSbbUsageMBeanProxies;

    public UsageMBeanLookup(String serviceName, String sbbName, SleeTCKTestUtils testUtils) throws UnrecognizedComponentException, ManagementException, TCKTestErrorException, InvalidArgumentException {
        this.testUtils = testUtils;
        this.namedSbbUsageMBeanProxies = new HashMap();
        ComponentIDLookup idLookup = new ComponentIDLookup(testUtils);
        this.serviceID = idLookup.lookupServiceID(serviceName, "jain.slee.tck", null);
        if (this.serviceID == null) {
            throw new TCKTestErrorException("ServiceID not found for " + serviceName);
        }
        this.sbbID = idLookup.lookupSbbID(sbbName, "jain.slee.tck", null);
        if (this.sbbID == null) {
            throw new TCKTestErrorException("SbbID not found for " + sbbName);
        }
        this.serviceUsageMBeanName = testUtils.getServiceManagementMBeanProxy().getServiceUsageMBean(this.serviceID);
        this.serviceUsageMBeanProxy = testUtils.getMBeanProxyFactory().createServiceUsageMBeanProxy(this.serviceUsageMBeanName);
        this.unnamedSbbUsageMBeanName = this.serviceUsageMBeanProxy.getSbbUsageMBean(this.sbbID);
        this.unnamedSbbUsageMBeanProxy = new UniversalUsageMBeanProxyImpl(this.unnamedSbbUsageMBeanName, testUtils.getMBeanFacade());
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public SbbID getSbbID() {
        return this.sbbID;
    }

    public ObjectName getServiceUsageMBeanName() {
        return this.serviceUsageMBeanName;
    }

    public ObjectName getUnnamedSbbUsageMBeanName() {
        return this.unnamedSbbUsageMBeanName;
    }

    public ServiceUsageMBeanProxy getServiceUsageMBeanProxy() {
        return this.serviceUsageMBeanProxy;
    }

    public UniversalUsageMBeanProxy getUnnamedSbbUsageMBeanProxy() {
        return this.unnamedSbbUsageMBeanProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniversalUsageMBeanProxy getNamedSbbUsageMBeanProxy(String name) throws TCKTestErrorException, ManagementException, InvalidArgumentException, UnrecognizedSbbException, UnrecognizedUsageParameterSetNameException {
        HashMap hashMap = this.namedSbbUsageMBeanProxies;
        synchronized (hashMap) {
            UniversalUsageMBeanProxy rProxy = (UniversalUsageMBeanProxy)this.namedSbbUsageMBeanProxies.get(name);
            if (rProxy == null) {
                ObjectName namedSbbUsageMBeanName = this.serviceUsageMBeanProxy.getSbbUsageMBean(this.sbbID, name);
                rProxy = new UniversalUsageMBeanProxyImpl(namedSbbUsageMBeanName, this.getUtils().getMBeanFacade());
                this.namedSbbUsageMBeanProxies.put(namedSbbUsageMBeanName, rProxy);
            }
            return rProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllMBeans() {
        HashMap hashMap = this.namedSbbUsageMBeanProxies;
        synchronized (hashMap) {
            Iterator toCloseIter = this.namedSbbUsageMBeanProxies.values().iterator();
            while (toCloseIter.hasNext()) {
                UniversalUsageMBeanProxy toClose = (UniversalUsageMBeanProxy)toCloseIter.next();
                try {
                    toClose.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            this.serviceUsageMBeanProxy.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.unnamedSbbUsageMBeanProxy.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected SleeTCKTestUtils getUtils() {
        return this.testUtils;
    }
}

