/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.common;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testsuite.usage.common.UniversalUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.impl.SbbUsageMBeanProxyImpl;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.slee.management.ManagementException;
import javax.slee.usage.SampleStatistics;

public class UniversalUsageMBeanProxyImpl
extends SbbUsageMBeanProxyImpl
implements UniversalUsageMBeanProxy {
    private ObjectName objName;
    private MBeanFacade facade;

    public UniversalUsageMBeanProxyImpl(ObjectName objName, MBeanFacade facade) {
        super(objName, facade);
        this.objName = objName;
        this.facade = facade;
    }

    public long getCounterParameter(String parameterName, boolean reset) throws ManagementException, TCKTestErrorException {
        try {
            Long rValue = (Long)this.facade.invoke(this.objName, this.parameterNameToGetter(parameterName), new Object[]{new Boolean(reset)}, new String[]{"boolean"});
            return rValue;
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public SampleStatistics getSampleParameter(String parameterName, boolean reset) throws ManagementException, TCKTestErrorException {
        try {
            return (SampleStatistics)this.facade.invoke(this.objName, this.parameterNameToGetter(parameterName), new Object[]{new Boolean(reset)}, new String[]{"boolean"});
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    private String parameterNameToGetter(String parameterName) {
        return "get" + Character.toUpperCase(parameterName.charAt(0)) + parameterName.substring(1);
    }
}

