/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.SbbUsageMBean;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanProxy;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;

public class Test2371Test
extends GenericUsageTest {
    private static final String PAUSE_BETWEEN_SENDS_MS_PARAM = "pauseBetweenSendsMs";
    private static final int TEST_ID = 2371;
    private static final int UPDATE_SETS_COUNT = 200;
    private static final int NOTIFICATIONS_TO_SKIP_PER_STEP = 3;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListener;
    private int pauseBetweenSendsMs;
    private volatile Exception fireEventsException;
    private int accumulatedCounterValue;
    private int accumulatedCounterValueExpected;
    private int accumulatedSampleCount;
    private int accumulatedSampleCountExpected;
    private int notificationsReceived;
    private int totalNotificationsExpected;

    public TCKTestResult run() throws Exception {
        long currentSampleCount;
        long currentCounterValue;
        GenericUsageSbbInstructions instructions = new GenericUsageSbbInstructions(null);
        instructions.addFirstCountIncrement(1L);
        instructions.addFirstCountIncrement(2L);
        instructions.addTimeBetweenNewConnectionsSamples(3L);
        instructions.addTimeBetweenNewConnectionsSamples(4L);
        this.totalNotificationsExpected = instructions.getTotalUpdates() * 200;
        this.accumulatedCounterValueExpected = 600;
        this.accumulatedSampleCountExpected = 400;
        this.getLog().info("Firing update events to the SBB");
        this.startFiringUpdateEvents(instructions);
        this.getLog().info("Receiving usage notifications. Will reset the usage parameters as the notifications are received...");
        GenericUsageMBeanProxy sbbUsageMBeanProxy = this.getGenericUsageMBeanLookup().getUnnamedGenericUsageMBeanProxy();
        while (this.notificationsReceived < this.totalNotificationsExpected && this.fireEventsException == null) {
            currentCounterValue = sbbUsageMBeanProxy.getFirstCount(true);
            this.accumulatedCounterValue = (int)((long)this.accumulatedCounterValue + currentCounterValue);
            this.getLog().fine("Accessed and reset counter value for parameter 'firstCount'. Counter value before reset=" + currentCounterValue + "; Accumulated counter value=" + this.accumulatedCounterValue);
            currentSampleCount = sbbUsageMBeanProxy.getTimeBetweenNewConnections(true).getSampleCount();
            this.accumulatedSampleCount = (int)((long)this.accumulatedSampleCount + currentSampleCount);
            this.getLog().fine("Accessed and reset sample parameter 'timeBetweenNewConnections'. Sample count before reset=" + currentSampleCount + "; Accumulated sample count=" + this.accumulatedSampleCount);
            int remainingNotifications = this.totalNotificationsExpected - this.notificationsReceived;
            int notificationsToSkip = Math.min(3, remainingNotifications);
            this.getLog().finer("Skipping " + notificationsToSkip + " usage notifications");
            for (int i = 0; i < notificationsToSkip; ++i) {
                try {
                    this.notificationListener.nextNotification();
                    continue;
                }
                catch (OperationTimedOutException e) {
                    Test2371Test test2371Test = this;
                    synchronized (test2371Test) {
                        throw this.fireEventsException != null ? this.fireEventsException : e;
                    }
                }
            }
            this.notificationsReceived += notificationsToSkip;
        }
        this.checkForSendException();
        this.getLog().info("Received all expected usage notifications");
        currentCounterValue = sbbUsageMBeanProxy.getFirstCount(true);
        this.accumulatedCounterValue = (int)((long)this.accumulatedCounterValue + currentCounterValue);
        this.getLog().fine("Accessed and reset counter value for parameter 'firstCount'. Counter value before reset=" + currentCounterValue + "; Accumulated counter value=" + this.accumulatedCounterValue);
        currentSampleCount = sbbUsageMBeanProxy.getTimeBetweenNewConnections(true).getSampleCount();
        this.accumulatedSampleCount = (int)((long)this.accumulatedSampleCount + currentSampleCount);
        this.getLog().fine("Accessed and reset sample parameter 'timeBetweenNewConnections'. Sample count before reset=" + currentSampleCount + "; Accumulated sample count=" + this.accumulatedSampleCount);
        if (this.accumulatedCounterValue != this.accumulatedCounterValueExpected) {
            return TCKTestResult.failed(2371, "Accumulated counter value did not match expected value. This may indicate that some reset operations were not atomic. accumulatedCounterValueExpected=" + this.accumulatedCounterValueExpected + ";accumulatedCounterValue=" + this.accumulatedCounterValue);
        }
        this.getLog().info("Accumulated counter value was as expected");
        if (this.accumulatedSampleCount != this.accumulatedSampleCountExpected) {
            return TCKTestResult.failed(2371, "Accumulated sample count did not match expected count. This may indicate that some reset operations were not atomic. accumulatedSampleCountExpected=" + this.accumulatedSampleCountExpected + ";accumulatedSampleCount=" + this.accumulatedSampleCount);
        }
        this.getLog().info("Accumulated sample count was as expected");
        this.getLog().fine("Checking that reply messages were received from the SBB");
        this.checkForSendException();
        this.receiveReplies();
        this.checkForSendException();
        return TCKTestResult.passed();
    }

    private void startFiringUpdateEvents(GenericUsageSbbInstructions instructions) throws Exception {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test2371Test-Activity");
        Object instructionsExported = instructions.toExported();
        new Thread(new FireEventsTask(resource, activityID, instructionsExported)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForSendException() throws Exception {
        Test2371Test test2371Test = this;
        synchronized (test2371Test) {
            if (this.fireEventsException != null) {
                throw this.fireEventsException;
            }
        }
    }

    private void receiveReplies() throws Exception {
        for (int i = 0; i < 200; ++i) {
            this.resourceListener.nextMessage();
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.notificationListener = new QueuingNotificationListener(this.utils());
        this.getGenericUsageMBeanLookup().getUnnamedGenericUsageMBeanProxy().addNotificationListener(this.notificationListener, null, null);
        this.pauseBetweenSendsMs = Integer.parseInt(this.utils().getTestParams().getProperty(PAUSE_BETWEEN_SENDS_MS_PARAM));
        if (this.pauseBetweenSendsMs < 0) {
            throw new TCKTestErrorException("Invalid value for 'pauseBetweenSendsMs' parameter (can't be negative): " + this.pauseBetweenSendsMs);
        }
        this.fireEventsException = null;
    }

    public void tearDown() throws Exception {
        if (this.notificationListener != null) {
            this.getGenericUsageMBeanLookup().getUnnamedGenericUsageMBeanProxy().removeNotificationListener(this.notificationListener);
        }
        super.tearDown();
    }

    private class FireEventsTask
    implements Runnable {
        private TCKResourceTestInterface resource;
        private TCKActivityID activityID;
        private Object instructionsExported;

        public FireEventsTask(TCKResourceTestInterface resource, TCKActivityID activityID, Object instructionsExported) {
            this.resource = resource;
            this.activityID = activityID;
            this.instructionsExported = instructionsExported;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Test2371Test.this.getLog().info("Started event firing thread.");
            Test2371Test.this.getLog().info("Will fire 200 events with a " + Test2371Test.this.pauseBetweenSendsMs + " ms pause between events.");
            try {
                for (int i = 0; i < 200; ++i) {
                    Test2371Test.this.getLog().finest("Firing update event");
                    this.resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.instructionsExported, this.activityID, null);
                    if (Test2371Test.this.pauseBetweenSendsMs <= 0) continue;
                    Test2371Test.this.getLog().finest("Waiting for " + Test2371Test.this.pauseBetweenSendsMs + " milliseconds");
                    FireEventsTask fireEventsTask = this;
                    synchronized (fireEventsTask) {
                        this.wait(Test2371Test.this.pauseBetweenSendsMs);
                        continue;
                    }
                }
            }
            catch (Exception e) {
                Test2371Test test2371Test = Test2371Test.this;
                synchronized (test2371Test) {
                    Test2371Test.this.fireEventsException = e;
                }
                Test2371Test.this.getLog().warning("Received Exception in event firing thread:");
                Test2371Test.this.getLog().warning(e);
            }
        }
    }
}

