/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.SbbUsageMBean;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanLookup;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanProxy;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import javax.slee.usage.SampleStatistics;

public class Test2326and2370Test
extends GenericUsageTest {
    private static final int RESET_FLAG_ASSERTION = 2326;
    private static final int RETURNS_PRESET_VALUE_ASSERTION = 2370;
    private GenericUsageMBeanLookup mBeanLookup;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListener;

    public TCKTestResult run() throws Exception {
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("Test2326and2370Test-Activity");
        GenericUsageSbbInstructions instructions = new GenericUsageSbbInstructions(null);
        instructions.addFirstCountIncrement(1L);
        instructions.addTimeBetweenNewConnectionsSamples(1L);
        this.getLog().fine("sending first update requests");
        this.sendInstructionsAndWait(activityID, instructions);
        GenericUsageMBeanProxy sbbUsageMBeanProxy = this.getGenericUsageMBeanLookup().getUnnamedGenericUsageMBeanProxy();
        this.getLog().info("first check: check that accessor returns non-reset value");
        long firstCount = sbbUsageMBeanProxy.getFirstCount(false);
        if (firstCount == 0L) {
            return TCKTestResult.failed(2370, "Accessor method for counter type parameter firstCount returned 0, after updates had been made. This may indicate that the counter has been illegally reset, or may indicate some other error preventing the counter being set. The reset argument was false.");
        }
        if (firstCount != 1L) {
            return TCKTestResult.error("Counter-type parameter firstCount was set to an unexpected value; should be 1. Actual value:" + firstCount);
        }
        this.getLog().info("check that accessor returns non-reset value after calling getFirstCount(false), by calling getFirstCount(false) again");
        firstCount = sbbUsageMBeanProxy.getFirstCount(false);
        if (firstCount == 0L) {
            return TCKTestResult.failed(2326, "Accessor method for counter type parameter firstCount returned 0, after updates had been made, after an accessor call passing false as the reset argument. This indicates that the counter has been illegally reset.");
        }
        if (firstCount != 1L) {
            return TCKTestResult.error("Counter-type parameter firstCount was set to an unexpected value; should be 1. Actual value:" + firstCount);
        }
        this.getLog().info("first check: check that accessor returns non-reset value");
        SampleStatistics sampleStatistics = sbbUsageMBeanProxy.getTimeBetweenNewConnections(false);
        if (sampleStatistics.getSampleCount() == 0L) {
            return TCKTestResult.failed(2370, "Accessor method for sample type parameter timeBetweenNewConnections returned 0 sample count, after updates had been made. This may indicate that the parameter has been illegally reset, or may indicate some other error preventing the parameter being updated. The reset argument was false.");
        }
        if (sampleStatistics.getSampleCount() != 1L) {
            return TCKTestResult.error("Sample-type parameter timeBetweenNewConnections  was had an unexpected sample count; should be 1. Actual value:" + sampleStatistics.getSampleCount());
        }
        this.getLog().info("check that accessor returns non-reset value after calling getTimeBetweenNewConnections(false), by calling getTimeBetweenNewConnections(false) again");
        sampleStatistics = sbbUsageMBeanProxy.getTimeBetweenNewConnections(false);
        if (sampleStatistics.getSampleCount() == 0L) {
            return TCKTestResult.failed(2326, "Accessor method for sample type parameter timeBetweenNewConnections returned sample count 0, after updates had been made, after an accessor call passing false as the reset argument. This indicates that the parameter has been illegally reset.");
        }
        if (sampleStatistics.getSampleCount() != 1L) {
            return TCKTestResult.error("Sample-type parameter timeBetweenNewConnections had an unexpected sample count; should be 1. Actual value:" + sampleStatistics.getSampleCount());
        }
        this.getLog().fine("sending second update requests");
        this.sendInstructionsAndWait(activityID, instructions);
        this.getLog().info("check that accessor returns non-reset value, by calling getFirstCount(true)");
        firstCount = sbbUsageMBeanProxy.getFirstCount(true);
        if (firstCount == 0L) {
            return TCKTestResult.failed(2370, "Accessor method for counter type parameter firstCount returned 0, after updates had been made. The reset argument was true, but this was the first request to reset the parameter. This indicates that the method did not return the pre-reset value.");
        }
        if (firstCount != 2L) {
            return TCKTestResult.error("Counter-type parameter firstCount was set to an unexpected value; should be 2. Actual value:" + firstCount);
        }
        this.getLog().info("check that accessor returns the reset value after calling getFirstCount(true), by calling getFirstCount(false)");
        firstCount = sbbUsageMBeanProxy.getFirstCount(false);
        if (firstCount == 2L) {
            return TCKTestResult.failed(2326, "Accessor method for counter type parameter firstCount returned 2, after an accessor call passing true as the reset argument, with no subsequent updates. The counter should have been reset to 0.");
        }
        if (firstCount != 0L) {
            return TCKTestResult.error("Counter-type parameter firstCount was set to an unexpected value; should be 0. Actual value:" + firstCount);
        }
        this.getLog().info("check that accessor returns non-reset value, by calling getTimeBetweenNewConnections(true)");
        sampleStatistics = sbbUsageMBeanProxy.getTimeBetweenNewConnections(true);
        if (sampleStatistics.getSampleCount() == 0L) {
            return TCKTestResult.failed(2370, "Accessor method for sample type parameter timeBetweenNewConnections returned 0 sample size count, after updates had been made. The reset argument was true, but this was the first request to reset the parameter. This indicates that the method did not return the pre-reset value.");
        }
        if (sampleStatistics.getSampleCount() != 2L) {
            return TCKTestResult.error("Sample-type parameter timeBetweenNewConnections had an unexpected sample count; should be 2. Actual value:" + sampleStatistics.getSampleCount());
        }
        this.getLog().info("check that accessor returns the reset value after calling getTimeBetweenNewConnections(true), by calling getTimeBetweenNewConnections(false)");
        sampleStatistics = sbbUsageMBeanProxy.getTimeBetweenNewConnections(false);
        if (sampleStatistics.getSampleCount() == 2L) {
            return TCKTestResult.failed(2326, "Accessor method for sample type parameter timeBetweenNewConnections returned sample count 2, after an accessor call passing true as the reset argument, with no subsequent updates. The parameter should have been reset.");
        }
        if (sampleStatistics.getSampleCount() != 0L) {
            return TCKTestResult.error("Sample-type parameter timeBetweenNewConnections had an unexpected sample count; should be 0. Actual value:" + sampleStatistics.getSampleCount());
        }
        this.getLog().info("parameter checks ok");
        return TCKTestResult.passed();
    }

    private void sendInstructionsAndWait(TCKActivityID activityID, GenericUsageSbbInstructions instructions) throws Exception {
        this.getLog().fine("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructions.toExported(), activityID, null);
        this.getLog().fine("waiting for replies");
        this.resourceListener.nextMessage();
        this.getLog().info("received replies");
        this.getLog().fine("waiting for usage notifications");
        for (int i = 0; i < instructions.getTotalUpdates(); ++i) {
            this.notificationListener.nextNotification();
        }
        this.getLog().info("received all " + instructions.getTotalUpdates() + " usage notifications");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.mBeanLookup = this.getGenericUsageMBeanLookup();
        this.notificationListener = new QueuingNotificationListener(this.utils());
        this.mBeanLookup.getUnnamedGenericUsageMBeanProxy().addNotificationListener(this.notificationListener, null, null);
    }

    public void tearDown() throws Exception {
        if (this.mBeanLookup != null && this.notificationListener != null) {
            this.mBeanLookup.getUnnamedGenericUsageMBeanProxy().removeNotificationListener(this.notificationListener);
        }
        super.tearDown();
    }
}

