/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions.isolation;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import java.rmi.RemoteException;
import java.util.Map;

public class Test2002Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final String WAIT_PERIOD_MS_PARAM = "waitPeriodMs";
    private static final String INITIAL_VALUE = "Test2002InitialValue";
    private static final String NEW_VALUE = "Test2002NewValue";
    private static final int EXPECTED_Y2_RESPONSES = 2;
    private TCKActivityID activityA;
    private TCKActivityID activityB;
    private QueuingResourceListener listener;
    private Object testLock = new Object();
    private Object sbbLock = new Object();
    private int receivedY2Responses;
    private String expectedValue;
    private boolean testCompleted;
    private TCKTestResult testResult = null;
    private boolean concurrentTest;
    private long testTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        this.testResult = TCKTestResult.passed();
        this.activityA = this.utils().getResourceInterface().createActivity("Test2002ActivityA");
        this.activityB = this.utils().getResourceInterface().createActivity("Test2002ActivityB");
        this.expectedValue = INITIAL_VALUE;
        this.listener = new ResourceListenerImpl(this.utils());
        this.setResourceListener(this.listener);
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", INITIAL_VALUE, this.activityA, null);
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", NEW_VALUE, this.activityA, null);
        Object object = this.testLock;
        synchronized (object) {
            this.testLock.wait(this.testTimeout * 2L);
        }
        return this.testResult;
    }

    public void setUp() throws Exception {
        this.testTimeout = Integer.parseInt(this.utils().getTestParams().getProperty(WAIT_PERIOD_MS_PARAM));
        this.setupService(SERVICE_DU_PATH_PARAM, true);
    }

    private void info(String message) {
        this.getLog().info(message);
    }

    private void setTestResult(TCKTestResult result) {
        this.testResult = result;
    }

    private class ResourceListenerImpl
    extends QueuingResourceListener {
        public ResourceListenerImpl(SleeTCKTestUtils utils) {
            super(utils);
        }

        public Object onSbbCall(Object argument) throws Exception {
            Map args = (Map)argument;
            String handlerName = (String)args.get("handler");
            String value = (String)args.get("value");
            Test2002Test.this.info("CALLTEST: " + handlerName + " : " + value);
            if (handlerName.equals("X1")) {
                this.x1Handler();
            } else if (handlerName.equals("X2")) {
                this.x2Handler();
            } else if (handlerName.equals("Y1")) {
                this.y1Handler();
            } else {
                this.y2Handler(value);
            }
            Test2002Test.this.info("CALLTEST-exit: " + handlerName);
            return null;
        }

        private void x1Handler() {
            Test2002Test.this.info("Sbb CMP value initialized");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void x2Handler() throws InterruptedException, RemoteException, TCKTestErrorException {
            try {
                Test2002Test.this.info("Firing Y2 event on activityB...");
                Test2002Test.this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2", null, Test2002Test.this.activityB, null);
                Object object = Test2002Test.this.sbbLock;
                synchronized (object) {
                    Test2002Test.this.sbbLock.wait(Test2002Test.this.testTimeout);
                }
                if (Test2002Test.this.receivedY2Responses == 0) {
                    Test2002Test.this.concurrentTest = false;
                } else {
                    Test2002Test.this.concurrentTest = true;
                }
                Test2002Test.this.info("The SLEE is allowing concurrent execution of the SBB entities: " + Test2002Test.this.concurrentTest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void y1Handler() {
            Test2002Test.this.info("In Y1 Handler waiting to notifyAll()");
            Object object = Test2002Test.this.sbbLock;
            synchronized (object) {
                Test2002Test.this.sbbLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void y2Handler(String value) throws InterruptedException, TCKTestErrorException, RemoteException {
            Test2002Test.this.info("In Y2 handler, attempting to notifyAll()");
            Object object = Test2002Test.this.sbbLock;
            synchronized (object) {
                Test2002Test.this.sbbLock.notifyAll();
            }
            if (!Test2002Test.this.concurrentTest) {
                Test2002Test.this.info("SLEE is not allowing concurrent execution");
                Test2002Test.this.testCompleted = true;
                return;
            }
            if (!value.equals(Test2002Test.this.expectedValue)) {
                Test2002Test.this.setTestResult(TCKTestResult.failed(2002, "Expected value: " + Test2002Test.this.expectedValue + " actual value: " + value));
                Test2002Test.this.testCompleted = true;
            }
            Test2002Test.this.receivedY2Responses++;
            if (Test2002Test.this.receivedY2Responses == 2) {
                Test2002Test.this.testCompleted = true;
            } else {
                Test2002Test.this.info("Firing Y1 event on activityA...");
                Test2002Test.this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", null, Test2002Test.this.activityA, null);
                object = Test2002Test.this.sbbLock;
                synchronized (object) {
                    Test2002Test.this.sbbLock.wait(Test2002Test.this.testTimeout);
                }
            }
        }
    }
}

