/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.HashMap;

public class Test905Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 905;
    private boolean exceptionThrown = false;
    private boolean rolledBack = false;
    private Object txnID = null;
    private Object txnID2 = null;
    private TCKResourceListener resourceListener;
    private FutureResult result;

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.getLog());
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test905InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils().getTestTimeout(), "Timeout waiting for test result.", 905);
    }

    public void setUp() throws Exception {
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.setupService(SERVICE_DU_PATH_PARAM);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            String type = (String)map.get("Type");
            Test905Test.this.getLog().fine("Received message " + type);
            if (type.equals("ExceptionThrown")) {
                boolean data = (Boolean)map.get("Data");
                Test905Test.this.exceptionThrown = data;
                return;
            }
            if (type.equals("RolledBack")) {
                boolean data = (Boolean)map.get("Data");
                Test905Test.this.rolledBack = data;
                return;
            }
            if (type.equals("TXN")) {
                Test905Test.this.txnID = map.get("Data");
                return;
            }
            if (type.equals("TXN2")) {
                Test905Test.this.txnID2 = map.get("Data");
                return;
            }
            if (type.equals("Result")) {
                if (!Test905Test.this.exceptionThrown) {
                    Test905Test.this.result.setFailed(906, "sbbExceptionThrown() method was not thrown.");
                    return;
                }
                if (!Test905Test.this.rolledBack) {
                    Test905Test.this.result.setFailed(908, "The transaction that RuntimeException was thrown in was not rolled back.");
                    return;
                }
                if (Test905Test.this.txnID == null) {
                    Test905Test.this.result.setError("The child event handler method was not invoked within a transaction.");
                    return;
                }
                if (Test905Test.this.txnID2 == null) {
                    Test905Test.this.result.setFailed(909, "The sbbRolledBack() method was not invoked within a transaction.");
                    return;
                }
                if (Test905Test.this.txnID == Test905Test.this.txnID2) {
                    Test905Test.this.result.setFailed(909, "The sbbRolledBack() method was not invoked in a separate transaction.");
                    return;
                }
                Test905Test.this.result.setPassed();
                return;
            }
            Test905Test.this.result.setError("Received unexpected message type from SBB: " + type);
        }

        public void onException(Exception e) throws RemoteException {
            Test905Test.this.getLog().warning("Received exception from SBB");
            Test905Test.this.getLog().warning(e);
            Test905Test.this.result.setError(e);
        }
    }
}

