/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import javax.slee.ActivityContextInterface;
import javax.slee.RolledBackContext;
import javax.slee.facilities.Level;

public abstract class Test2508ChildSbb
extends BaseTCKSbb {
    public static final String EXCEPTION_MESSAGE = "Test2508RuntimeException";

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
        this.createTraceSafe(Level.INFO, "Test2508ChildSbb:sbbExceptionThrown()");
        if (exception instanceof RuntimeException && exception.getMessage().equals(EXCEPTION_MESSAGE)) {
            this.createTraceSafe(Level.INFO, "sbbExceptionThrown was invoked on the child SBB with the RuntimeException thrown from a local interface method");
            this.sendSbbMessageSafe("SBB_EXCEPTION_THROWN_CHILD");
        } else {
            TCKSbbUtils.handleException(new TCKTestErrorException("sbbExceptionThrown() invoked for an unexpected exception. event=" + event + ";aci=" + aci, exception));
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
        this.createTraceSafe(Level.INFO, "Test2508ChildSbb:sbbRolledBack()");
        this.sendSbbMessageSafe("SBB_ROLLED_BACK_CHILD");
    }

    public void throwRuntimeException() {
        throw new RuntimeException(EXCEPTION_MESSAGE);
    }

    private void sendSbbMessageSafe(String message) {
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(message);
        }
        catch (Exception ex) {
            TCKSbbUtils.handleException(ex);
        }
    }
}

