/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.transactions.StatusUtil;
import com.opencloud.sleetck.lib.testsuite.transactions.Test1109314ProfileCMP;
import com.opencloud.sleetck.lib.testsuite.transactions.Test1109314ResourceAdaptor;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.slee.profile.ProfileTable;
import javax.slee.transaction.SleeTransaction;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.RollbackException;

public class Test1109314MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    public static final String PROFILE_TABLE_NAME = "Test1109314ProfileTable";
    public static final String PROFILE_NAME = "Test1109314Table";
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;
    private Future future;
    private long blockTimeout;
    private Test1109314ResourceAdaptor ra;

    public Test1109314MessageListener(Test1109314ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    public boolean handleMessage(Object message) throws RemoteException {
        HashMap map = (HashMap)message;
        this.blockTimeout = 2000L;
        if (map.get("Timeout") != null) {
            this.blockTimeout = (Long)map.get("Timeout");
        }
        if (this.testCommit() && this.testStatus() && this.testRollback()) {
            this.msgSender.sendSuccess(1109314, "Test completed successfully.");
        }
        return true;
    }

    private boolean testCommit() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            String value;
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            Test1109314ProfileCMP profile = (Test1109314ProfileCMP)profileTable.find(PROFILE_NAME);
            profile.setStringValue("newValue");
            this.future = new Future();
            MyThread thread = new MyThread(txnManager, profileTable);
            thread.start();
            try {
                value = (String)this.future.getValue(this.blockTimeout);
            }
            catch (Future.TimeoutException e) {
                this.msgSender.sendLogMsg("Request to concurrently access profile CMP field timed out, possibly due to a SLEE implementation with pessimistic locking? " + e);
                txn.rollback();
                return true;
            }
            if ("newValue".equals(value)) {
                this.msgSender.sendFailure(1109134, "Change to profile CMP field should not have been visible from separate TXN");
                return false;
            }
            this.msgSender.sendLogMsg("Change to profile CMP field was not visible from separate TXN as expected.");
            value = profile.getStringValue();
            if (!"newValue".equals(value)) {
                this.msgSender.sendFailure(1109134, "Change to profile CMP field should have been visible from current TXN");
                return false;
            }
            this.msgSender.sendLogMsg("Change to profile CMP field was visible from current TXN as expected.");
            txn.commit();
            txn = txnManager.beginSleeTransaction();
            profile = (Test1109314ProfileCMP)profileTable.find(PROFILE_NAME);
            value = profile.getStringValue();
            if (!"newValue".equals(value)) {
                this.msgSender.sendFailure(1109314, "Change to profile CMP field should have been visible after the TXN committed.");
                return false;
            }
            this.msgSender.sendLogMsg("Change to profile CMP field was visible after TXN commit as expected.");
            this.future = new Future();
            thread = new MyThread(txnManager, profileTable);
            thread.start();
            try {
                value = (String)this.future.getValue(this.blockTimeout);
            }
            catch (Future.TimeoutException e) {
                this.msgSender.sendLogMsg("Request to concurrently access profile CMP field timed out, possibly due to a SLEE implementation with pessimistic locking? " + e);
                return true;
            }
            if (!"newValue".equals(value)) {
                this.msgSender.sendFailure(1109132, "Change to profile CMP field should have been visible from separate TXN after the original TXN committed.");
                return false;
            }
            this.msgSender.sendLogMsg("Change to profile CMP field was visible from separate TXN after TXN commit as expected.");
            txn.setRollbackOnly();
            try {
                txn.commit();
                this.msgSender.sendFailure(1109315, "commit() should have thrown a RollbackException as TXN was previously marked for rollback.");
                return false;
            }
            catch (RollbackException e) {
                this.msgSender.sendLogMsg("Exception was thrown as expected: " + (Object)((Object)e));
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109315, "Wrong type of exception thrown, expected javax.transaction.RollbackException.", e);
                return false;
            }
            txn = txnManager.beginSleeTransaction();
            txn.setRollbackOnly();
            try {
                txn.rollback();
                this.msgSender.sendLogMsg("Though marked via 'setRollbackOnly()' TXN still successfully rolled back as expected.");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109336, "Though previously marked via 'setRollbackOnly()' when calling rollback() on the TXN this still should have succeeded. Instead an exception occured: ", e);
                return false;
            }
            txn = txnManager.beginSleeTransaction();
            txn.asyncCommit(null);
            try {
                txn.commit();
                this.msgSender.sendFailure(1109319, "commit() should throw an IllegalStateException if current thread is not associated with a TXN.");
                return false;
            }
            catch (IllegalStateException e) {
                this.msgSender.sendLogMsg("As expected, commit() threw an IllegalStateException as current thread is not associated with a TXN." + e);
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109319, "Wrong type of Exception thrown, expected java.lang.IllegalStateException.", e);
                return false;
            }
        }
        catch (Exception e) {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private boolean testStatus() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            txn = txnManager.beginSleeTransaction();
            try {
                String status = StatusUtil.statusToString(txn.getStatus());
                if (StatusUtil.INVALID.equals(status)) {
                    this.msgSender.sendFailure(1109326, "Transaction.getStatus() returned a value different to the constants defined in the javax.transaction.Status interface.");
                    return false;
                }
                this.msgSender.sendLogMsg("Transaction.getStatus() returned current status of TXN: " + status);
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109326, "Exception thrown when trying to query current TXN status.", e);
                return false;
            }
            txn.commit();
        }
        catch (Exception e) {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private boolean testRollback() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            String value;
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            Test1109314ProfileCMP profile = (Test1109314ProfileCMP)profileTable.find(PROFILE_NAME);
            profile.setStringValue("newValue2");
            this.future = new Future();
            MyThread thread = new MyThread(txnManager, profileTable);
            thread.start();
            try {
                value = (String)this.future.getValue(this.blockTimeout);
            }
            catch (Future.TimeoutException e) {
                this.msgSender.sendLogMsg("Request to concurrently access profile CMP field timed out, possibly due to a SLEE implementation with pessimistic locking? " + e);
                return true;
            }
            if ("newValue2".equals(value)) {
                this.msgSender.sendFailure(1109134, "Change to profile CMP field should not have been visible from separate TXN");
                return false;
            }
            this.msgSender.sendLogMsg("Change to profile CMP field was not visible from separate TXN as expected.");
            value = profile.getStringValue();
            if (!"newValue2".equals(value)) {
                this.msgSender.sendFailure(1109134, "Change to profile CMP field should have been visible from current TXN");
                return false;
            }
            this.msgSender.sendLogMsg("Change to profile CMP field was visible from current TXN as expected.");
            txn.rollback();
            txn = txnManager.beginSleeTransaction();
            profile = (Test1109314ProfileCMP)profileTable.find(PROFILE_NAME);
            value = profile.getStringValue();
            if ("newValue2".equals(value)) {
                this.msgSender.sendFailure(1109332, "Changes should be rolled back and thus not visible from original Thread.");
                return false;
            }
            this.msgSender.sendLogMsg("Changes were rolled back and are thus not visible to original Thread.");
            this.future = new Future();
            thread = new MyThread(txnManager, profileTable);
            thread.start();
            try {
                value = (String)this.future.getValue(this.blockTimeout);
            }
            catch (Future.TimeoutException e) {
                this.msgSender.sendLogMsg("Request to concurrently access profile CMP field, timed out, probably due to a SLEE implementation with pessimistic locking!? " + e);
                return true;
            }
            if ("newValue2".equals(value)) {
                this.msgSender.sendFailure(1109132, "Changes should be rolled back and thus not visible from separate Thread.");
                return false;
            }
            this.msgSender.sendLogMsg("Changes were rolled back and are thus not visible to separate Thread.");
            txn.commit();
        }
        catch (Exception e) {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private class MyThread
    extends Thread {
        private SleeTransactionManager txnManager;
        private ProfileTable profileTable;

        public MyThread(SleeTransactionManager txnManager, ProfileTable profileTable) {
            this.txnManager = txnManager;
            this.profileTable = profileTable;
        }

        public void run() {
            SleeTransaction txn = null;
            try {
                txn = this.txnManager.beginSleeTransaction();
            }
            catch (Exception e) {
                Test1109314MessageListener.this.msgSender.sendException(e);
            }
            try {
                Test1109314ProfileCMP profile = (Test1109314ProfileCMP)this.profileTable.find(Test1109314MessageListener.PROFILE_NAME);
                String value = profile.getStringValue();
                Test1109314MessageListener.this.future.setValue(value);
                txn.commit();
            }
            catch (Exception e) {
                try {
                    if (txn != null) {
                        txn.rollback();
                    }
                }
                catch (Exception ex) {
                    Test1109314MessageListener.this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                    Test1109314MessageListener.this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
                }
            }
        }
    }
}

