/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.transactions.Test1109238ResourceAdaptor;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.naming.NamingException;
import javax.slee.transaction.CommitListener;
import javax.slee.transaction.SleeTransaction;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class Test1109238MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    private Test1109238ResourceAdaptor ra;
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;

    public Test1109238MessageListener(Test1109238ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    public boolean handleMessage(Object message) throws RemoteException {
        SleeTransactionManager txManager = null;
        try {
            Future future = new Future();
            try {
                txManager = this.ra.getTransactionManager();
            }
            catch (NamingException e) {
                this.msgSender.sendError("Could not look up transaction manager.", e);
                return true;
            }
            SleeTransaction txn = txManager.beginSleeTransaction();
            try {
                txManager.asyncCommit(null);
                this.msgSender.sendLogMsg("asyncCommit(null) did not cause any exceptions as expected.");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109345, "Exception occured when calling TXNManager.asyncCommit(null).");
                return true;
            }
            txn = txManager.beginSleeTransaction();
            MyCommitListener listener = new MyCommitListener(future);
            txn.asyncCommit((CommitListener)listener);
            if (null != txManager.getSleeTransaction()) {
                this.msgSender.sendFailure(1109239, "There is still a transaction associated with this thread.");
                return false;
            }
            try {
                txManager.asyncCommit(null);
                this.msgSender.sendFailure(1109244, "SleeTransactionManager.asyncCommit() did not throw IllegalStateException");
                return true;
            }
            catch (IllegalStateException e) {
                String result;
                this.msgSender.sendLogMsg("asyncCommit() threw IllegalStateException as expected when called while no TXN is active.");
                try {
                    result = (String)future.getValue(5000L);
                }
                catch (Future.TimeoutException e2) {
                    this.msgSender.sendFailure(1109243, "Timout occured while waiting for the CommitListner callbacks to be called.", e2);
                    return true;
                }
                if (!"committed".equals(result)) {
                    this.msgSender.sendFailure(1109243, "The CommitListener's committed() method shoud have been called but instead the " + result + "() method was called.");
                    return true;
                }
                this.msgSender.sendLogMsg("CommitListener.committed() was called as expected.");
                if (txn.getStatus() != 3) {
                    this.msgSender.sendFailure(1109241, "Transaction status is not Status.STATUS_COMITTED.");
                    return true;
                }
                this.msgSender.sendLogMsg("At some point after calling asyncCommit() the TXN status was Status.STATUS_COMITTED as expected.");
                txn = txManager.beginSleeTransaction();
                txManager.setRollbackOnly();
                future = new Future();
                listener = new MyCommitListener(future);
                txManager.asyncCommit((CommitListener)listener);
                try {
                    result = (String)future.getValue(5000L);
                }
                catch (Future.TimeoutException e3) {
                    this.msgSender.sendFailure(1109243, "Timout occured while waiting for the CommitListner callbacks to be called.", e3);
                    return true;
                }
                if (!"rolledBack".equals(result)) {
                    this.msgSender.sendFailure(1109243, "The CommitListener's rolledBack() method shoud have been called but instead the " + result + "() method was executed.");
                    return true;
                }
                this.msgSender.sendLogMsg("CommitListener.rolledBack() was called as expected.");
                if (txn.getStatus() != 4) {
                    this.msgSender.sendFailure(1109240, "Outcome of the TXN commit should have been 'rolledBack'.");
                    return true;
                }
                this.msgSender.sendLogMsg("Outcome of the TXN commit was 'rolledBack' as expected.");
                this.msgSender.sendSuccess(1109238, "Test completed successfully.");
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            try {
                if (null != txManager.getSleeTransaction()) {
                    txManager.getSleeTransaction().rollback();
                }
            }
            catch (SystemException e2) {
                this.msgSender.sendLogMsg("Exception occured when trying to safely rollback leftover TXN, this is however not the immediate cause for an eventual failure of the test: " + (Object)((Object)e2));
            }
        }
        return true;
    }

    public class MyCommitListener
    implements CommitListener {
        private Future future;

        public MyCommitListener(Future future) {
            this.future = future;
        }

        public void committed() {
            this.future.setValue("committed");
        }

        public void heuristicMixed(HeuristicMixedException hme) {
            this.future.setValue("heuristicMixed");
        }

        public void heuristicRollback(HeuristicRollbackException hrbe) {
            this.future.setValue("heuristicRollback");
        }

        public void rolledBack(RollbackException rbe) {
            this.future.setValue("rolledBack");
        }

        public void systemException(SystemException se) {
            this.future.setValue("systemException");
        }
    }
}

