/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.lifecycle;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;
import javax.slee.SbbID;
import javax.slee.ServiceID;

public abstract class Test1106001Sbb
extends BaseTCKSbb {
    private SbbID mySbbId;
    private ServiceID myServiceId;
    private SbbContext context;

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
        TCKSbbUtils.handleException(new TCKTestErrorException("sbbExceptionThrown() called. event=" + event + ";aci=" + aci, exception));
    }

    public void sbbRolledBack(RolledBackContext context) {
        TCKSbbUtils.handleException(new TCKTestErrorException("Unexpected roll back. event=" + context.getEvent() + ";aci=" + context.getActivityContextInterface()));
    }

    public void setSbbContext(SbbContext context) {
        this.context = context;
        this.mySbbId = context.getSbb();
        this.myServiceId = context.getService();
        this.checkSbbAndService("setSbbContext");
    }

    public void unsetSbbContext() {
        this.context = null;
    }

    public void sbbCreate() throws CreateException {
        this.checkSbbAndService("sbbCreate");
    }

    public void sbbPostCreate() throws CreateException {
        this.checkSbbAndService("sbbPostCreate");
    }

    public void sbbActivate() {
        this.checkSbbAndService("sbbActivate");
    }

    public void sbbPassivate() {
        this.checkSbbAndService("sbbPassivate");
    }

    public void sbbLoad() {
        this.checkSbbAndService("sbbLoad");
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void onTCKResourceEventX1(TCKResourceEventX ev, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(null);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void checkSbbAndService(String methodName) {
        TCKTestResult result = null;
        HashMap<String, Object> message = new HashMap<String, Object>();
        if (this.mySbbId != this.context.getSbb()) {
            result = TCKTestResult.failed(1106006, "SBB Context returned a different SBB!");
        }
        if (this.myServiceId != this.context.getService()) {
            result = TCKTestResult.failed(1106006, "SBB Context returned a different Service!");
        }
        message.put("TCKResult", result);
        message.put("Method", methodName);
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(message);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }
}

