/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.activitycontext;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;

public class Test1106033Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1106033;
    public static final String PROFILE_TABLE_NAME = "myAddressProfileTable";
    public static final String PROFILE_NAME = "myAddressProfile";
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;
    private TCKResourceTestInterface resource;
    private QueuingResourceListener queue;
    private ProfileProvisioningMBeanProxy profileProvisioningMBeanProxy;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        TCKActivityID activityID = this.resource.createActivity("Test1106033InitialActivity");
        this.resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        TCKSbbMessage message = this.queue.nextMessage();
        HashMap messageContents = (HashMap)message.getMessage();
        Boolean passed = (Boolean)messageContents.get("Result");
        String msgString = (String)messageContents.get("Message");
        this.utils.getLog().info("Received message from SBB: " + msgString);
        if (!passed.booleanValue()) {
            return TCKTestResult.failed(1106033, msgString);
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        this.resource = this.utils.getResourceInterface();
        this.queue = new QueuingResourceListener(this.utils);
        this.resource.setResourceListener(this.queue);
        ProfileUtils profileUtils = new ProfileUtils(this.utils);
        this.profileProvisioningMBeanProxy = profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profSpecID = new ProfileSpecificationID("AddressProfileSpec", "javax.slee", "1.1");
        this.profileProvisioningMBeanProxy.createProfileTable(profSpecID, PROFILE_TABLE_NAME);
        ObjectName profile = this.profileProvisioningMBeanProxy.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileMBeanProxy proxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.utils.getLog().fine("Created profile myAddressProfile for profile table myAddressProfileTable");
        proxy.commitProfile();
        proxy.closeProfile();
    }

    public void tearDown() throws Exception {
        this.profileProvisioningMBeanProxy.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        this.profileProvisioningMBeanProxy.removeProfileTable(PROFILE_TABLE_NAME);
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

