/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanLookup;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.SbbUsageMBeanProxy;
import java.rmi.RemoteException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.management.DeployableUnitID;
import javax.slee.usage.UsageNotification;

public class Test2223Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int COUNTER_TYPE_ASSERTION = 2223;
    private static final int SAMPLE_TYPE_ASSERTION = 2232;
    private NotificationListener listener;
    private SbbUsageMBeanProxy usagembean;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private UsageMBeanLookup mBeanLookup;
    private boolean receivedCounterNotification;
    private boolean receivedSampleNotification;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test522InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 2223);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.listener = new UsageNotificationListenerImpl();
        this.mBeanLookup = new UsageMBeanLookup("Test2223TestService", "Test2223Test", this.utils);
        this.usagembean = this.mBeanLookup.getUnnamedSbbUsageMBeanProxy();
        this.usagembean.addNotificationListener(this.listener, null, null);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        if (this.usagembean != null) {
            this.usagembean.removeNotificationListener(this.listener);
        }
        if (this.mBeanLookup != null) {
            this.mBeanLookup.closeAllMBeans();
        }
        this.utils.getLog().fine("Cleaning up activities");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().removeResourceListener();
    }

    public class UsageNotificationListenerImpl
    implements NotificationListener {
        public final synchronized void handleNotification(Notification notification, Object o) {
            if (notification instanceof UsageNotification) {
                UsageNotification n = (UsageNotification)notification;
                String parameterName = n.getUsageParameterName();
                if (parameterName.equals("foo")) {
                    if (n.getValue() == 10L) {
                        Test2223Test.this.receivedCounterNotification = true;
                    } else {
                        Test2223Test.this.result.setFailed(2223, "Value of 'foo' usage parameter notification was not 10 as it should have been.");
                    }
                } else if (parameterName.equals("bar")) {
                    if (n.getValue() == 20L) {
                        Test2223Test.this.receivedSampleNotification = true;
                    } else {
                        Test2223Test.this.result.setFailed(2232, "Value of 'bar' usage parameter notification was not 20 as it should have been.");
                    }
                } else {
                    Test2223Test.this.result.setError("Received notification for unrecognized usage parameter name: " + parameterName);
                }
                if (Test2223Test.this.receivedCounterNotification && Test2223Test.this.receivedSampleNotification) {
                    Test2223Test.this.result.setPassed();
                }
            }
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test2223Test.this.result.setError("Unexpected sbb message received: " + message);
        }

        public void onException(Exception e) throws RemoteException {
            Test2223Test.this.utils.getLog().warning("Received exception from SBB");
            Test2223Test.this.utils.getLog().warning(e);
            Test2223Test.this.result.setError(e);
        }
    }
}

